/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk;

import io.stargate.sdk.api.TokenProvider;
import io.stargate.sdk.grpc.ServiceGrpc;
import io.stargate.sdk.http.ServiceHttp;
import java.util.ArrayList;
import java.util.List;

public class StargateDataCenter {
    private String id;
    private TokenProvider tokenProvider;
    private List<ServiceHttp> restNodes = new ArrayList<ServiceHttp>();
    private List<ServiceHttp> docNodes = new ArrayList<ServiceHttp>();
    private List<ServiceGrpc> grpcNodes = new ArrayList<ServiceGrpc>();
    private List<ServiceHttp> graphqlNodes = new ArrayList<ServiceHttp>();

    public StargateDataCenter(String id) {
        this.id = id;
    }

    public StargateDataCenter withRest() {
        return this.addRestService(new ServiceHttp("sgv2-rest", "http://localhost:8082", "http://localhost:8082/stargate/health"));
    }

    public StargateDataCenter addRestService(ServiceHttp s) {
        this.restNodes.add(s);
        return this;
    }

    public StargateDataCenter addGraphQLService(ServiceHttp s) {
        this.graphqlNodes.add(s);
        return this;
    }

    public StargateDataCenter addDocumenService(ServiceHttp s) {
        this.docNodes.add(s);
        return this;
    }

    public StargateDataCenter addGrpcService(ServiceGrpc s) {
        this.grpcNodes.add(s);
        return this;
    }

    public StargateDataCenter(String id, TokenProvider tokenProvider) {
        this(id);
        this.tokenProvider = tokenProvider;
    }

    public TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public String getId() {
        return this.id;
    }

    public void setTokenProvider(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public List<ServiceHttp> getRestNodes() {
        return this.restNodes;
    }

    public List<ServiceHttp> getDocNodes() {
        return this.docNodes;
    }

    public List<ServiceGrpc> getGrpcNodes() {
        return this.grpcNodes;
    }

    public List<ServiceHttp> getGraphqlNodes() {
        return this.graphqlNodes;
    }
}

