/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.TypedDriverOption;
import com.datastax.oss.driver.api.core.cql.Row;
import com.evanlennick.retry4j.config.RetryConfig;
import io.stargate.sdk.ServiceDatacenter;
import io.stargate.sdk.ServiceDeployment;
import io.stargate.sdk.StargateClientBuilder;
import io.stargate.sdk.audit.ServiceCallObserver;
import io.stargate.sdk.data.DataApiClient;
import io.stargate.sdk.doc.StargateDocumentApiClient;
import io.stargate.sdk.gql.StargateGraphQLApiClient;
import io.stargate.sdk.grpc.StargateGrpcApiClient;
import io.stargate.sdk.http.RetryHttpClient;
import io.stargate.sdk.rest.StargateRestApiClient;
import io.stargate.sdk.utils.AnsiUtils;
import io.stargate.sdk.utils.Utils;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.hc.client5.http.config.RequestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StargateClient
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StargateClient.class);
    private final StargateClientBuilder conf;
    private CqlSession cqlSession;
    protected String currentDatacenter;
    protected StargateRestApiClient apiRestClient;
    protected StargateDocumentApiClient apiDocumentClient;
    protected StargateGraphQLApiClient apiGraphQLClient;
    protected StargateGrpcApiClient apiGrpcClient;
    protected DataApiClient apiDataClient;

    public StargateClient() {
        this(StargateClient.builder());
    }

    public StargateClient(StargateClientBuilder config) {
        this.conf = config;
        this.currentDatacenter = this.resolveDataCenterName(config);
        if (config.isEnabledCql()) {
            this.cqlSession = this.initCqlSession();
            LOGGER.info("+ API Cql      :[" + AnsiUtils.green((String)"ENABLED") + "]");
        }
        if (config.getStargateNodesDC().isEmpty()) {
            this.apiRestClient = new StargateRestApiClient();
            this.apiDocumentClient = new StargateDocumentApiClient();
            this.apiGraphQLClient = new StargateGraphQLApiClient();
            this.apiDataClient = new DataApiClient();
            if (config.isEnabledGrpc()) {
                this.apiGrpcClient = new StargateGrpcApiClient();
            }
        } else {
            ServiceDeployment restDeploy = new ServiceDeployment();
            ServiceDeployment docDeploy = new ServiceDeployment();
            ServiceDeployment gqlDeploy = new ServiceDeployment();
            ServiceDeployment jsonDeploy = new ServiceDeployment();
            config.getStargateNodesDC().values().forEach(dc -> {
                restDeploy.addDatacenter(new ServiceDatacenter(dc.getId(), dc.getTokenProvider(), dc.getRestNodes()));
                docDeploy.addDatacenter(new ServiceDatacenter(dc.getId(), dc.getTokenProvider(), dc.getDocNodes()));
                gqlDeploy.addDatacenter(new ServiceDatacenter(dc.getId(), dc.getTokenProvider(), dc.getGraphqlNodes()));
                jsonDeploy.addDatacenter(new ServiceDatacenter(dc.getId(), dc.getTokenProvider(), dc.getJsonNodes()));
            });
            this.apiRestClient = new StargateRestApiClient(restDeploy);
            this.apiDocumentClient = new StargateDocumentApiClient(docDeploy);
            this.apiGraphQLClient = new StargateGraphQLApiClient(gqlDeploy);
            this.apiDataClient = new DataApiClient(jsonDeploy);
            if (config.isEnabledGrpc()) {
                ServiceDeployment grpcDeploy = new ServiceDeployment();
                config.getStargateNodesDC().values().forEach(dc -> grpcDeploy.addDatacenter(new ServiceDatacenter(dc.getId(), dc.getTokenProvider(), dc.getGrpcNodes())));
                this.apiGrpcClient = new StargateGrpcApiClient(grpcDeploy);
            }
        }
        if (config.getRetryConfig() != null) {
            RetryHttpClient.withRetryConfig((RetryConfig)config.getRetryConfig());
        }
        if (config.getRequestConfig() != null) {
            RetryHttpClient.withRequestConfig((RequestConfig)config.getRequestConfig());
        }
        if (!config.getObservers().isEmpty()) {
            for (Map.Entry<String, ServiceCallObserver> obs : config.getObservers().entrySet()) {
                RetryHttpClient.registerListener((String)obs.getKey(), (ServiceCallObserver)obs.getValue());
            }
        }
    }

    private String resolveDataCenterName(StargateClientBuilder config) {
        if (!Utils.hasLength((String)config.getLocalDatacenter())) {
            String cqlDc = (String)config.getCqlOptions().get(TypedDriverOption.LOAD_BALANCING_LOCAL_DATACENTER);
            if (Utils.hasLength((String)cqlDc)) {
                config.withLocalDatacenter(cqlDc);
                LOGGER.info("Datacenter value defined in cql configuration {}", (Object)cqlDc);
            } else if (!config.getStargateNodesDC().isEmpty()) {
                Set<String> dcs = config.getStargateNodesDC().keySet();
                String dcPicked = dcs.iterator().next();
                config.withLocalDatacenter(dcPicked);
                LOGGER.info("Datacenter from node topology '{}' ( '{}' dc found)", (Object)dcPicked, (Object)dcs.size());
            } else {
                LOGGER.info("Datacenter name is " + AnsiUtils.green((String)"'{}'"), (Object)"dc1");
                config.withLocalDatacenter("dc1");
            }
        }
        return config.getLocalDatacenter();
    }

    public CqlSession initCqlSession() {
        if (null != this.cqlSession && !this.cqlSession.isClosed()) {
            this.cqlSession.close();
            this.cqlSession = null;
        }
        if (this.conf.isEnabledCql()) {
            if (this.conf.getCqlSession() != null) {
                this.cqlSession = this.conf.getCqlSession();
            } else {
                try {
                    List configContactPointsDC;
                    String scb = (String)this.conf.getCqlOptions().get(this.currentDatacenter, TypedDriverOption.CLOUD_SECURE_CONNECT_BUNDLE);
                    if (Utils.hasLength((String)scb)) {
                        this.conf.withCqlCloudSecureConnectBundle(scb);
                        this.conf.setLocalDatacenter(this.currentDatacenter);
                    }
                    if ((configContactPointsDC = (List)this.conf.getCqlOptions().get(this.currentDatacenter, TypedDriverOption.CONTACT_POINTS)) != null && !configContactPointsDC.isEmpty()) {
                        this.conf.withCqlContactPoints(configContactPointsDC.toArray(new String[0]));
                        this.conf.withLocalDatacenter(this.currentDatacenter);
                    }
                }
                catch (NullPointerException npe) {
                    System.out.println("No DC profile");
                }
                DriverConfigLoader configLoader = this.conf.getCqlDriverConfigLoaderBuilder().build();
                CqlSessionBuilder sessionBuilder = (CqlSessionBuilder)CqlSession.builder().withConfigLoader(configLoader);
                if (null != this.conf.getCqlMetricsRegistry()) {
                    sessionBuilder.withMetricRegistry(this.conf.getCqlMetricsRegistry());
                }
                if (null != this.conf.getCqlRequestTracker()) {
                    sessionBuilder.withRequestTracker(this.conf.getCqlRequestTracker());
                }
                this.cqlSession = (CqlSession)sessionBuilder.build();
            }
        }
        if (this.cqlSession != null) {
            String currentDC = Objects.requireNonNull((Row)this.cqlSession.execute("SELECT data_center from system.local").one()).getString("data_center");
            if (this.cqlSession.getKeyspace().isPresent()) {
                LOGGER.info("+ CqlSession   :[" + AnsiUtils.green((String)"ENABLED") + "] with keyspace [" + AnsiUtils.cyan((String)"{}") + "] and dc [" + AnsiUtils.cyan((String)"{}") + "]", this.cqlSession.getKeyspace().get(), (Object)currentDC);
            } else {
                LOGGER.info("+ CqlSession   :[" + AnsiUtils.green((String)"ENABLED") + "]");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (!StargateClient.this.cqlSession.isClosed()) {
                        StargateClient.this.cqlSession.close();
                        LOGGER.info("Closing CqlSession.");
                    }
                }
            });
        } else {
            LOGGER.info("+ CqlSession   :[" + AnsiUtils.red((String)"DISABLED") + "]");
        }
        return this.cqlSession;
    }

    public static StargateClientBuilder builder() {
        return new StargateClientBuilder();
    }

    @Override
    public void close() {
        if (null != this.cqlSession && !this.cqlSession.isClosed()) {
            this.cqlSession.close();
            LOGGER.info("Closing CqlSession.");
        }
    }

    public Optional<CqlSession> cqlSession() {
        return Optional.ofNullable(this.cqlSession);
    }

    public DataApiClient apiData() {
        if (this.apiDataClient == null) {
            throw new IllegalStateException("Json Api is not available please provide a service deployment for Json");
        }
        return this.apiDataClient;
    }

    public StargateDocumentApiClient apiDocument() {
        if (this.apiDocumentClient == null) {
            throw new IllegalStateException("Document Api is not available please provide a service deployment for Documentxs");
        }
        return this.apiDocumentClient;
    }

    public StargateRestApiClient apiRest() {
        if (this.apiRestClient == null) {
            throw new IllegalStateException("REST Data Api is not available please provide a service deployment for Rest Data");
        }
        return this.apiRestClient;
    }

    public StargateGraphQLApiClient apiGraphQL() {
        if (this.apiGraphQLClient == null) {
            throw new IllegalStateException("GraphQL Api is not available please provide a service deployment for GraphQL");
        }
        return this.apiGraphQLClient;
    }

    public StargateGrpcApiClient apiGrpc() {
        if (this.apiGrpcClient == null) {
            throw new IllegalStateException("GRPC Api is not available please provide a service deployment for gRPC");
        }
        return this.apiGrpcClient;
    }

    public void setCurrentDatacenter(String currentDatacenter) {
        this.currentDatacenter = currentDatacenter;
    }
}

