/*
 * Decompiled with CFR 0.152.
 */
package greycat;

import greycat.generator.Generator;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Stack;

public class GeneratorMain {
    static void deleteDir(File dir) {
        Stack<File> stack = new Stack<File>();
        stack.push(dir);
        while (!stack.isEmpty()) {
            if (((File)stack.lastElement()).isDirectory()) {
                File[] currList = ((File)stack.lastElement()).listFiles();
                if (currList.length > 0) {
                    for (File curr : currList) {
                        stack.push(curr);
                    }
                    continue;
                }
                ((File)stack.pop()).delete();
                continue;
            }
            ((File)stack.pop()).delete();
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length != 1) {
            System.err.println("usage: greycatGen <model.gcm>");
            return;
        }
        String model = args[0];
        try {
            File tempJavaGen = Files.createTempDirectory("greycat-gen-cli", new FileAttribute[0]).toFile();
            File tempGen = new File("gen");
            if (tempGen.exists()) {
                GeneratorMain.deleteDir(tempGen);
            }
            tempGen.mkdirs();
            Generator generator = new Generator();
            generator.parse(new File(model));
            String gcVersion = System.getProperty("greycat.version");
            generator.generate("model", "gen", tempJavaGen, tempGen, true, true, gcVersion.substring(0, gcVersion.indexOf(46)), "1.0.0", null);
            GeneratorMain.deleteDir(tempJavaGen);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Hello From Java Cli " + model);
    }
}

