/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.netlet;

import com.datatorrent.netlet.EventLoop;
import com.datatorrent.netlet.Listener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientListener
implements Listener.ClientListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractClientListener.class);
    private static final SelectionKey invalidSelectionKey = new SelectionKey(){

        @Override
        public SelectableChannel channel() {
            return null;
        }

        @Override
        public Selector selector() {
            return null;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public void cancel() {
        }

        @Override
        public int interestOps() {
            return 0;
        }

        @Override
        public SelectionKey interestOps(int ops) {
            return this;
        }

        @Override
        public int readyOps() {
            return 0;
        }

        public String toString() {
            return "Invalid Selection key";
        }
    };
    protected SelectionKey key = invalidSelectionKey;

    private boolean isSuspended(int ops) {
        return (this.key.interestOps() & ops) == 0;
    }

    private boolean suspendIfResumed(int ops) {
        int interestOps = this.key.interestOps();
        if ((interestOps & ops) == ops) {
            this.key.interestOps(interestOps & ~ops);
            logger.debug("{} suspended {}", (Object)this, (Object)(ops == 1 ? "read" : "write"));
            return true;
        }
        return false;
    }

    private boolean resumeIfSuspended(int ops) {
        int interestOps = this.key.interestOps();
        if ((interestOps & ops) == 0) {
            this.key.interestOps(interestOps | ops).selector().wakeup();
            logger.debug("{} resumed {}", (Object)this, (Object)(ops == 1 ? "read" : "write"));
            return true;
        }
        return false;
    }

    protected void shutdownIO(boolean read) {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        SocketChannel channel = (SocketChannel)this.key.channel();
        try {
            Method method = channel.getClass().getDeclaredMethod(read ? "shutdownInput" : "shutdownOutput", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)channel, new Object[0]);
            return;
        }
        catch (NoSuchMethodException e) {
            logger.warn("{}", (Object)this, (Object)e);
        }
        catch (IllegalAccessException e) {
            logger.warn("{}", (Object)this, (Object)e);
        }
        catch (InvocationTargetException e) {
            logger.warn("{}", (Object)this, (Object)e);
        }
        Socket socket = channel.socket();
        try {
            if (read) {
                socket.shutdownInput();
            } else {
                socket.shutdownOutput();
            }
        }
        catch (IOException e) {
            logger.warn("{}", (Object)this, (Object)e);
        }
    }

    public boolean isConnected() {
        return this.key.isValid() && ((SocketChannel)this.key.channel()).isConnected();
    }

    public boolean isReadSuspended() {
        return this.isSuspended(1);
    }

    public boolean isWriteSuspended() {
        return this.isSuspended(4);
    }

    public boolean suspendReadIfResumed() {
        return this.suspendIfResumed(1);
    }

    public boolean suspendWriteIfResumed() {
        return this.suspendIfResumed(4);
    }

    public boolean resumeReadIfSuspended() {
        return this.resumeIfSuspended(1);
    }

    public boolean resumeWriteIfSuspended() {
        return this.resumeIfSuspended(4);
    }

    @Override
    public void registered(SelectionKey key) {
        if (this.key == invalidSelectionKey) {
            this.key = key;
        } else {
            logger.error("{} is registered with the different key: registered key={}, key={}.", new Object[]{this, this.key, key});
            this.unregistered(this.key);
            this.key = key;
        }
    }

    @Override
    public void unregistered(SelectionKey key) {
        if (this.key != key) {
            logger.warn("{} is registered with the different key: registered key={}, key={}.", new Object[]{this, this.key, key});
        } else {
            this.key = invalidSelectionKey;
        }
    }

    @Override
    public void connected() {
        logger.debug("{}", (Object)this);
    }

    @Override
    public void disconnected() {
        logger.debug("{}", (Object)this);
    }

    @Override
    public void handleException(Exception cce, EventLoop el) {
        logger.error("Exception in event loop {}", (Object)el, (Object)cce);
    }

    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + "{key=" + this.key.toString() + (this.key.isValid() ? ", channel=" + this.key.channel() + ", interestOps=" + this.key.interestOps() : "") + "}";
    }
}

