/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.netlet;

import com.datatorrent.netlet.AbstractClientListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReadOnlyClient
extends AbstractClientListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractReadOnlyClient.class);

    public abstract ByteBuffer buffer();

    public abstract void read(int var1);

    @Override
    public void connected() {
        super.connected();
        this.shutdownIO(false);
        this.suspendWriteIfResumed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void read() throws IOException {
        ByteBuffer buffer;
        SocketChannel channel = (SocketChannel)this.key.channel();
        int read = channel.read(buffer = this.buffer());
        if (read > 0) {
            this.read(read);
        } else if (read == -1) {
            try {
                channel.close();
            }
            finally {
                this.disconnected();
                this.unregistered(this.key);
            }
        } else if (buffer.remaining() > 0) {
            logger.error("{} read {} bytes into byte buffer {}", new Object[]{this, read, buffer});
        } else {
            this.suspendReadIfResumed();
        }
    }

    @Override
    public final void write() throws IOException {
        if (this.suspendWriteIfResumed()) {
            logger.warn("{} OP_WRITE should be disabled", (Object)this);
        } else {
            logger.error("{} write is not expected", (Object)this);
        }
    }

    @Override
    public boolean resumeWriteIfSuspended() {
        throw new UnsupportedOperationException();
    }
}

