/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.netlet;

import com.datatorrent.netlet.AbstractReadOnlyClient;
import java.nio.ByteBuffer;
import java.util.Arrays;

public abstract class AbstractReadOnlyLengthPrependerClient
extends AbstractReadOnlyClient {
    protected byte[] buffer;
    protected ByteBuffer byteBuffer;
    protected int size;
    protected int writeOffset;
    protected int readOffset;

    public AbstractReadOnlyLengthPrependerClient() {
        this(65536);
    }

    public AbstractReadOnlyLengthPrependerClient(int readBufferSize) {
        this(new byte[readBufferSize], 0);
    }

    public AbstractReadOnlyLengthPrependerClient(byte[] buffer, int position) {
        this.buffer = buffer;
        this.byteBuffer = ByteBuffer.wrap(buffer);
        this.byteBuffer.position(position);
        this.writeOffset = position;
        this.readOffset = position;
    }

    protected int readSize() {
        if (this.readOffset < this.writeOffset) {
            byte tmp;
            int offset = this.readOffset;
            if ((tmp = this.buffer[this.readOffset++]) >= 0) {
                return tmp;
            }
            if (this.readOffset < this.writeOffset) {
                int integer = tmp & 0x7F;
                if ((tmp = this.buffer[this.readOffset++]) >= 0) {
                    return integer | tmp << 7;
                }
                if (this.readOffset < this.writeOffset) {
                    integer |= (tmp & 0x7F) << 7;
                    if ((tmp = this.buffer[this.readOffset++]) >= 0) {
                        return integer | tmp << 14;
                    }
                    if (this.readOffset < this.writeOffset) {
                        integer |= (tmp & 0x7F) << 14;
                        if ((tmp = this.buffer[this.readOffset++]) >= 0) {
                            return integer | tmp << 21;
                        }
                        if (this.readOffset < this.writeOffset) {
                            integer |= (tmp & 0x7F) << 21;
                            if ((tmp = this.buffer[this.readOffset++]) >= 0) {
                                return integer | tmp << 28;
                            }
                            throw new NumberFormatException("Invalid varint at location " + offset + " => " + Arrays.toString(Arrays.copyOfRange(this.buffer, offset, this.readOffset)));
                        }
                    }
                }
            }
            this.readOffset = offset;
        }
        return -1;
    }

    public void beginMessage() {
    }

    public abstract void onMessage(byte[] var1, int var2, int var3);

    public void endMessage() {
    }

    @Override
    public ByteBuffer buffer() {
        return this.byteBuffer;
    }

    @Override
    public void read(int len) {
        this.beginMessage();
        this.writeOffset += len;
        while (true) {
            if (this.size == 0) {
                this.size = this.readSize();
                if (this.size != -1) continue;
                if (this.writeOffset == this.buffer.length && this.readOffset > this.writeOffset - 5) {
                    byte[] newArray = new byte[this.buffer.length];
                    System.arraycopy(this.buffer, this.readOffset, newArray, 0, this.writeOffset - this.readOffset);
                    this.buffer = newArray;
                    this.writeOffset -= this.readOffset;
                    this.readOffset = 0;
                    this.byteBuffer = ByteBuffer.wrap(this.buffer);
                    this.byteBuffer.position(this.writeOffset);
                }
                this.size = 0;
                this.endMessage();
                return;
            }
            if (this.writeOffset - this.readOffset < this.size) break;
            this.onMessage(this.buffer, this.readOffset, this.size);
            this.readOffset += this.size;
            this.size = 0;
        }
        if (this.writeOffset == this.buffer.length) {
            if (this.size > this.buffer.length) {
                int newsize;
                for (newsize = this.buffer.length; newsize < this.size; newsize <<= 1) {
                }
                byte[] newArray = new byte[newsize];
                System.arraycopy(this.buffer, this.readOffset, newArray, 0, this.writeOffset - this.readOffset);
                this.buffer = newArray;
                this.writeOffset -= this.readOffset;
                this.readOffset = 0;
                this.byteBuffer = ByteBuffer.wrap(newArray);
                this.byteBuffer.position(this.writeOffset);
            } else {
                byte[] newArray = new byte[this.buffer.length];
                System.arraycopy(this.buffer, this.readOffset, newArray, 0, this.writeOffset - this.readOffset);
                this.buffer = newArray;
                this.writeOffset -= this.readOffset;
                this.readOffset = 0;
                this.byteBuffer = ByteBuffer.wrap(this.buffer);
                this.byteBuffer.position(this.writeOffset);
            }
            this.endMessage();
            return;
        }
        this.endMessage();
    }
}

