/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.netlet;

import com.datatorrent.netlet.AbstractServer;
import com.datatorrent.netlet.DefaultEventLoop;
import com.datatorrent.netlet.EventLoop;
import com.datatorrent.netlet.Listener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServer<T extends Listener.ClientListener>
extends AbstractServer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultServer.class);
    private final Constructor<T> constructor;

    public static <T extends Listener.ClientListener> SocketAddress start(DefaultEventLoop eventLoop, Class<T> clientListenerClass) {
        return DefaultServer.start(eventLoop, 0, clientListenerClass);
    }

    public static <T extends Listener.ClientListener> SocketAddress start(DefaultEventLoop eventLoop, int port, Class<T> clientListenerClass) {
        return DefaultServer.start(eventLoop, null, port, clientListenerClass);
    }

    public static <T extends Listener.ClientListener> SocketAddress start(DefaultEventLoop eventLoop, String host, int port, Class<T> clientListenerClass) {
        final CountDownLatch registered = new CountDownLatch(1);
        DefaultServer server = new DefaultServer<T>(clientListenerClass){

            @Override
            public void registered(SelectionKey key) {
                super.registered(key);
                registered.countDown();
            }

            @Override
            public void handleException(Exception cce, EventLoop el) {
                super.handleException(cce, el);
                registered.countDown();
            }

            @Override
            public SocketAddress getServerAddress() {
                try {
                    registered.await();
                }
                catch (InterruptedException e) {
                    logger.error("", (Throwable)e);
                    throw new RuntimeException(e);
                }
                return super.getServerAddress();
            }
        };
        eventLoop.start(host, port, server);
        return server.getServerAddress();
    }

    public DefaultServer(Class<T> clientListenerClass) {
        try {
            this.constructor = clientListenerClass.getDeclaredConstructor(new Class[0]);
            this.constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Listener.ClientListener getClientConnection(SocketChannel client, ServerSocketChannel server) {
        try {
            return (Listener.ClientListener)this.constructor.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            logger.error("{}", this.constructor, (Object)e);
            throw new RuntimeException(e.getTargetException());
        }
        catch (InstantiationException e) {
            logger.error("{}", this.constructor, (Object)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            logger.error("{}", this.constructor, (Object)e);
            throw new RuntimeException(e);
        }
    }
}

