/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.netlet;

import com.datatorrent.netlet.DefaultEventLoop;
import com.datatorrent.netlet.Listener;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizedEventLoop
extends DefaultEventLoop {
    private static final Logger logger = LoggerFactory.getLogger(OptimizedEventLoop.class);

    public OptimizedEventLoop(String id) throws IOException {
        super(id);
        try {
            ClassLoader systemClassLoader = System.getSecurityManager() == null ? ClassLoader.getSystemClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return ClassLoader.getSystemClassLoader();
                }
            });
            Class<?> selectorClass = Class.forName("sun.nio.ch.SelectorImpl", false, systemClassLoader);
            if (selectorClass.isAssignableFrom(this.selector.getClass())) {
                Field selectedKeys = selectorClass.getDeclaredField("selectedKeys");
                Field publicSelectedKeys = selectorClass.getDeclaredField("publicSelectedKeys");
                selectedKeys.setAccessible(true);
                publicSelectedKeys.setAccessible(true);
                SelectedSelectionKeySet keys = new SelectedSelectionKeySet(1024);
                selectedKeys.set(this.selector, keys);
                publicSelectedKeys.set(this.selector, keys);
                logger.debug("Instrumented an optimized java.util.Set into: {}", (Object)this.selector);
            }
        }
        catch (Exception e) {
            logger.debug("Failed to instrument an optimized java.util.Set into: {}", (Object)this.selector, (Object)e);
        }
    }

    @Override
    protected void runEventLoop() {
        Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
        if (selectedKeys instanceof SelectedSelectionKeySet) {
            this.runEventLoop((SelectedSelectionKeySet)selectedKeys);
        } else {
            super.runEventLoop();
        }
    }

    private void runEventLoop(SelectedSelectionKeySet keys) {
        while (this.alive) {
            try {
                int size;
                if (size > 0) {
                    Runnable task;
                    for (size = this.tasks.size(); this.alive && size > 0 && (task = (Runnable)this.tasks.poll()) != null; --size) {
                        try {
                            task.run();
                            continue;
                        }
                        catch (RuntimeException e) {
                            logger.error("Unexpected exception in task {}. Terminating {}.", new Object[]{task, this, e});
                            this.disconnectAllKeysAndShutdown();
                        }
                    }
                    if (this.selector.selectNow() == 0) {
                        continue;
                    }
                } else if (this.selector.select() == 0) {
                    continue;
                }
            }
            catch (IOException e) {
                logger.error("Unexpected exception in selector {}. Terminating {}.", new Object[]{this.selector, this, e});
                this.disconnectAllKeysAndShutdown();
            }
            keys.forEach(this);
        }
    }

    private void disconnectAllKeysAndShutdown() {
        for (SelectionKey selectionKey : this.selector.keys()) {
            SelectableChannel channel;
            if (!selectionKey.isValid() || (channel = selectionKey.channel()) == null || !channel.isOpen()) continue;
            Listener l = (Listener)selectionKey.attachment();
            try {
                selectionKey.channel().close();
                if (l == null) continue;
                if (l instanceof Listener.ClientListener) {
                    ((Listener.ClientListener)l).disconnected();
                }
                l.unregistered(selectionKey);
            }
            catch (IOException e) {
                if (l != null) {
                    l.handleException(e, this);
                    continue;
                }
                logger.warn("Exception while closing channel {} on unregistered key {}", new Object[]{channel, selectionKey, e});
            }
        }
        this.alive = false;
        this.selector.wakeup();
    }

    private static final class SelectedSelectionKeySet
    extends AbstractSet<SelectionKey> {
        private SelectionKey[] keys;
        private int pos = 0;

        private SelectedSelectionKeySet(int size) {
            this.keys = new SelectionKey[size];
        }

        public void forEach(DefaultEventLoop defaultEventLoop) {
            while (defaultEventLoop.alive && this.pos > 0) {
                SelectionKey sk = this.keys[--this.pos];
                this.keys[this.pos] = null;
                if (!sk.isValid()) continue;
                try {
                    defaultEventLoop.handleSelectedKey(sk);
                }
                catch (Exception ex) {
                    Listener l = (Listener)sk.attachment();
                    if (l != null) {
                        l.handleException(ex, defaultEventLoop);
                        continue;
                    }
                    logger.warn("Exception on unattached SelectionKey {} ", (Object)sk, (Object)ex);
                }
            }
        }

        @Override
        public boolean add(SelectionKey key) {
            if (key == null) {
                return false;
            }
            this.keys[this.pos++] = key;
            if (this.pos == this.keys.length) {
                SelectionKey[] keys = new SelectionKey[this.keys.length << 1];
                System.arraycopy(this.keys, 0, keys, 0, this.pos);
                this.keys = keys;
            }
            return true;
        }

        @Override
        public int size() {
            return this.pos;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return false;
            }
            int i = this.pos;
            while (i > 0) {
                if (!o.equals(this.keys[--i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<SelectionKey> iterator() {
            throw new UnsupportedOperationException();
        }
    }
}

