/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.netlet;

import com.datatorrent.netlet.WriteOnlyClient;
import com.datatorrent.netlet.util.Slice;
import com.datatorrent.netlet.util.VarInt;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteOnlyLengthPrependerClient
extends WriteOnlyClient {
    private static final Logger logger = LoggerFactory.getLogger(WriteOnlyLengthPrependerClient.class);
    private boolean newMessage = true;

    public WriteOnlyLengthPrependerClient(int sendBufferCapacity) {
        this(65536, sendBufferCapacity);
    }

    public WriteOnlyLengthPrependerClient(int writeBufferCapacity, int sendBufferCapacity) {
        super(writeBufferCapacity, sendBufferCapacity);
    }

    @Override
    public void write() throws IOException {
        Slice slice;
        int remaining = this.writeBuffer.remaining();
        while ((slice = (Slice)this.sendQueue.peek()) != null) {
            if (this.newMessage) {
                if (remaining < 5 && (this.channelWrite() == 0 || (remaining = this.writeBuffer.remaining()) < 5)) {
                    return;
                }
                remaining -= VarInt.write(slice.length, this.writeBuffer);
                this.newMessage = false;
            }
            while (remaining < slice.length) {
                if (remaining > 0) {
                    this.writeBuffer.put(slice.buffer, slice.offset, remaining);
                    slice.offset += remaining;
                    slice.length -= remaining;
                }
                if (this.channelWrite() == 0) {
                    return;
                }
                remaining = this.writeBuffer.remaining();
            }
            this.writeBuffer.put(slice.buffer, slice.offset, slice.length);
            slice.buffer = null;
            remaining -= slice.length;
            this.freeQueue.offer(this.sendQueue.poll());
            this.newMessage = true;
        }
        this.channelWrite();
    }
}

