/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.netlet.util;

import com.datatorrent.netlet.util.UnsafeBlockingQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircularBuffer<T>
implements UnsafeBlockingQueue<T> {
    private final T[] buffer;
    private final int buffermask;
    private final int spinMillis;
    protected volatile long tail;
    protected volatile long head;
    private static final Logger logger = LoggerFactory.getLogger(CircularBuffer.class);

    public CircularBuffer(int n, int spin) {
        int i;
        for (i = 1; i < n; i <<= 1) {
        }
        this.buffer = new Object[i];
        this.buffermask = i - 1;
        this.spinMillis = spin;
    }

    private CircularBuffer(T[] buffer, int buffermask, int spinMillis) {
        this.buffer = buffer;
        this.buffermask = buffermask;
        this.spinMillis = spinMillis;
    }

    public CircularBuffer(int n) {
        this(n, 10);
    }

    @Override
    public boolean add(T e) {
        if (this.head - this.tail <= (long)this.buffermask) {
            this.buffer[(int)(this.head & (long)this.buffermask)] = e;
            ++this.head;
            return true;
        }
        throw new IllegalStateException("Collection is full");
    }

    @Override
    public T remove() {
        if (this.head > this.tail) {
            int pos = (int)(this.tail & (long)this.buffermask);
            T t = this.buffer[pos];
            this.buffer[pos] = null;
            ++this.tail;
            return t;
        }
        throw new IllegalStateException("Collection is empty");
    }

    @Override
    public T peek() {
        if (this.head > this.tail) {
            return this.buffer[(int)(this.tail & (long)this.buffermask)];
        }
        return null;
    }

    @Override
    public int size() {
        return (int)(this.head - this.tail);
    }

    public int capacity() {
        return this.buffermask + 1;
    }

    @Override
    public int drainTo(Collection<? super T> container) {
        int size = this.size();
        while (this.head > this.tail) {
            container.add(this.buffer[(int)(this.tail & (long)this.buffermask)]);
            ++this.tail;
        }
        return size;
    }

    public String toString() {
        return "head=" + this.head + ", tail=" + this.tail + ", capacity=" + (this.buffermask + 1);
    }

    @Override
    public boolean offer(T e) {
        if (this.head - this.tail <= (long)this.buffermask) {
            this.buffer[(int)(this.head & (long)this.buffermask)] = e;
            ++this.head;
            return true;
        }
        return false;
    }

    @Override
    public void put(T e) throws InterruptedException {
        int spinMillis = 0;
        while (true) {
            if (this.head - this.tail < (long)this.buffermask) {
                this.buffer[(int)(this.head & (long)this.buffermask)] = e;
                ++this.head;
                return;
            }
            Thread.sleep(spinMillis);
            spinMillis = Math.min(this.spinMillis, spinMillis + 1);
        }
    }

    @Override
    public boolean offer(T e, long timeout, TimeUnit unit) throws InterruptedException {
        long millis = unit.toMillis(timeout);
        int spinMillis = 0;
        do {
            if (this.head - this.tail < (long)this.buffermask) {
                this.buffer[(int)(this.head & (long)this.buffermask)] = e;
                ++this.head;
                return true;
            }
            Thread.sleep(spinMillis);
        } while ((millis -= (long)(spinMillis = Math.min(this.spinMillis, spinMillis + 1))) >= 0L);
        return false;
    }

    @Override
    public T take() throws InterruptedException {
        int spinMillis = 0;
        while (true) {
            if (this.head > this.tail) {
                int pos = (int)(this.tail & (long)this.buffermask);
                T t = this.buffer[pos];
                this.buffer[pos] = null;
                ++this.tail;
                return t;
            }
            Thread.sleep(spinMillis);
            spinMillis = Math.min(this.spinMillis, spinMillis + 1);
        }
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        long millis = unit.toMillis(timeout);
        int spinMillis = 0;
        do {
            if (this.head > this.tail) {
                int pos = (int)(this.tail & (long)this.buffermask);
                T t = this.buffer[pos];
                this.buffer[pos] = null;
                ++this.tail;
                return t;
            }
            Thread.sleep(spinMillis);
        } while ((millis -= (long)(spinMillis = Math.min(this.spinMillis, spinMillis + 1))) >= 0L);
        return null;
    }

    @Override
    public int remainingCapacity() {
        return this.buffermask + 1 - (int)(this.head - this.tail);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int drainTo(Collection<? super T> collection, int maxElements) {
        int i = -1;
        while (++i < maxElements && this.head > this.tail) {
            int pos = (int)(this.tail & (long)this.buffermask);
            collection.add(this.buffer[pos]);
            this.buffer[pos] = null;
            ++this.tail;
        }
        return i;
    }

    @Override
    public T poll() {
        if (this.head > this.tail) {
            int pos = (int)(this.tail & (long)this.buffermask);
            T t = this.buffer[pos];
            this.buffer[pos] = null;
            ++this.tail;
            return t;
        }
        return null;
    }

    @Override
    public T pollUnsafe() {
        int pos = (int)(this.tail & (long)this.buffermask);
        T t = this.buffer[pos];
        this.buffer[pos] = null;
        ++this.tail;
        return t;
    }

    @Override
    public T element() {
        if (this.head > this.tail) {
            return this.buffer[(int)(this.tail & (long)this.buffermask)];
        }
        throw new IllegalStateException("Collection is empty");
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public Iterator<T> getFrozenIterator() {
        return new FrozenIterator();
    }

    public Iterable<T> getFrozenIterable() {
        return new FrozenIterator();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return CircularBuffer.this.head > CircularBuffer.this.tail;
            }

            @Override
            public T next() {
                int pos = (int)(CircularBuffer.this.tail & (long)CircularBuffer.this.buffermask);
                Object t = CircularBuffer.this.buffer[pos];
                ((CircularBuffer)CircularBuffer.this).buffer[pos] = null;
                ++CircularBuffer.this.tail;
                return t;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Object[] toArray() {
        int count = (int)(this.head - this.tail);
        Object[] array = new Object[count];
        for (int i = 0; i < count; ++i) {
            int pos = (int)(this.tail & (long)this.buffermask);
            array[i] = this.buffer[pos];
            this.buffer[pos] = null;
            ++this.tail;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int count = (int)(this.head - this.tail);
        if (a.length < count) {
            a = new Object[count];
        }
        for (int i = 0; i < count; ++i) {
            int pos = (int)(this.tail & (long)this.buffermask);
            a[i] = this.buffer[pos];
            this.buffer[pos] = null;
            ++this.tail;
        }
        return a;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        this.head = 0L;
        this.tail = 0L;
        Arrays.fill(this.buffer, null);
    }

    @Override
    public T peekUnsafe() {
        return this.buffer[(int)(this.tail & (long)this.buffermask)];
    }

    public CircularBuffer<T> getWhitehole(final String exceptionMessage) {
        CircularBuffer cb = new CircularBuffer<T>(this.buffer, this.buffermask, this.spinMillis){

            @Override
            public boolean add(T e) {
                throw new IllegalStateException(exceptionMessage);
            }

            @Override
            public void put(T e) throws InterruptedException {
                while (true) {
                    Thread.sleep(CircularBuffer.this.spinMillis);
                }
            }

            @Override
            public boolean offer(T e) {
                return false;
            }

            @Override
            public boolean offer(T e, long timeout, TimeUnit unit) throws InterruptedException {
                long millis = unit.toMillis(timeout);
                Thread.sleep(millis);
                return false;
            }

            @Override
            public int remainingCapacity() {
                return 0;
            }

            @Override
            public boolean addAll(Collection<? extends T> c) {
                throw new IllegalStateException(exceptionMessage);
            }
        };
        cb.head = this.head;
        cb.tail = this.tail;
        return cb;
    }

    private class FrozenIterator
    implements Iterator<T>,
    Iterable<T>,
    Cloneable {
        private final long frozenHead;
        private final long frozenTail;
        private long tail;

        FrozenIterator() {
            this(circularBuffer.head, circularBuffer.tail);
        }

        FrozenIterator(long frozenHead, long frozenTail) {
            this.frozenHead = frozenHead;
            this.frozenTail = frozenTail;
            this.tail = frozenTail;
        }

        @Override
        public boolean hasNext() {
            return this.tail < this.frozenHead;
        }

        @Override
        public T next() {
            return CircularBuffer.this.buffer[(int)(this.tail++ & (long)CircularBuffer.this.buffermask)];
        }

        @Override
        public void remove() {
            ((CircularBuffer)CircularBuffer.this).buffer[(int)(this.tail - 1L & (long)((CircularBuffer)CircularBuffer.this).buffermask)] = null;
        }

        @Override
        public Iterator<T> iterator() {
            return new FrozenIterator(this.frozenHead, this.frozenTail);
        }
    }
}

