/*
 * Decompiled with CFR 0.152.
 */
package com.datomic.lucene.analysis;

import com.datomic.lucene.analysis.CharArraySet;
import com.datomic.lucene.analysis.TokenFilter;
import com.datomic.lucene.analysis.TokenStream;
import com.datomic.lucene.analysis.tokenattributes.CharTermAttribute;
import com.datomic.lucene.analysis.tokenattributes.KeywordAttribute;
import com.datomic.lucene.util.Version;
import java.io.IOException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeywordMarkerFilter
extends TokenFilter {
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final CharArraySet keywordSet;

    public KeywordMarkerFilter(TokenStream in, CharArraySet keywordSet) {
        super(in);
        this.keywordSet = keywordSet;
    }

    public KeywordMarkerFilter(TokenStream in, Set<?> keywordSet) {
        this(in, keywordSet instanceof CharArraySet ? (CharArraySet)keywordSet : CharArraySet.copy(Version.LUCENE_31, keywordSet));
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (this.keywordSet.contains(this.termAtt.buffer(), 0, this.termAtt.length())) {
                this.keywordAttr.setKeyword(true);
            }
            return true;
        }
        return false;
    }
}

