/*
 * Decompiled with CFR 0.152.
 */
package com.datomic.lucene.index;

import com.datomic.lucene.index.BufferedDeletesStream;
import com.datomic.lucene.index.FrozenBufferedDeletes;
import com.datomic.lucene.index.Term;
import com.datomic.lucene.search.Query;
import com.datomic.lucene.util.RamUsageEstimator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BufferedDeletes {
    static final int BYTES_PER_DEL_TERM = 8 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 40 + 24;
    static final int BYTES_PER_DEL_DOCID = 2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 8 + 4;
    static final int BYTES_PER_DEL_QUERY = 5 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 16 + 8 + 24;
    final AtomicInteger numTermDeletes = new AtomicInteger();
    final Map<Term, Integer> terms;
    final Map<Query, Integer> queries = new HashMap<Query, Integer>();
    final List<Integer> docIDs = new ArrayList<Integer>();
    public static final Integer MAX_INT = Integer.MAX_VALUE;
    final AtomicLong bytesUsed = new AtomicLong();
    private static final boolean VERBOSE_DELETES = false;
    long gen;

    public BufferedDeletes(boolean sortTerms) {
        this.terms = sortTerms ? new TreeMap<Term, Integer>() : new HashMap<Term, Integer>();
    }

    public String toString() {
        String s = "gen=" + this.gen;
        if (this.numTermDeletes.get() != 0) {
            s = s + " " + this.numTermDeletes.get() + " deleted terms (unique count=" + this.terms.size() + ")";
        }
        if (this.queries.size() != 0) {
            s = s + " " + this.queries.size() + " deleted queries";
        }
        if (this.docIDs.size() != 0) {
            s = s + " " + this.docIDs.size() + " deleted docIDs";
        }
        if (this.bytesUsed.get() != 0L) {
            s = s + " bytesUsed=" + this.bytesUsed.get();
        }
        return s;
    }

    void update(BufferedDeletes in) {
        this.numTermDeletes.addAndGet(in.numTermDeletes.get());
        for (Map.Entry<Term, Integer> entry : in.terms.entrySet()) {
            Term term = entry.getKey();
            if (!this.terms.containsKey(term)) {
                this.bytesUsed.addAndGet(BYTES_PER_DEL_TERM);
            }
            this.terms.put(term, MAX_INT);
        }
        for (Map.Entry<Serializable, Integer> entry : in.queries.entrySet()) {
            Query query = (Query)entry.getKey();
            if (!this.queries.containsKey(query)) {
                this.bytesUsed.addAndGet(BYTES_PER_DEL_QUERY);
            }
            this.queries.put(query, MAX_INT);
        }
    }

    void update(FrozenBufferedDeletes in) {
        this.numTermDeletes.addAndGet(in.numTermDeletes);
        for (Term term : in.terms) {
            if (!this.terms.containsKey(term)) {
                this.bytesUsed.addAndGet(BYTES_PER_DEL_TERM);
            }
            this.terms.put(term, MAX_INT);
        }
        for (int queryIdx = 0; queryIdx < in.queries.length; ++queryIdx) {
            Query query = in.queries[queryIdx];
            if (!this.queries.containsKey(query)) {
                this.bytesUsed.addAndGet(BYTES_PER_DEL_QUERY);
            }
            this.queries.put(query, MAX_INT);
        }
    }

    public void addQuery(Query query, int docIDUpto) {
        Integer current = this.queries.put(query, docIDUpto);
        if (current == null) {
            this.bytesUsed.addAndGet(BYTES_PER_DEL_QUERY);
        }
    }

    public void addDocID(int docID) {
        this.docIDs.add(docID);
        this.bytesUsed.addAndGet(BYTES_PER_DEL_DOCID);
    }

    public void addTerm(Term term, int docIDUpto) {
        Integer current = this.terms.get(term);
        if (current != null && docIDUpto < current) {
            return;
        }
        this.terms.put(term, docIDUpto);
        this.numTermDeletes.incrementAndGet();
        if (current == null) {
            this.bytesUsed.addAndGet(BYTES_PER_DEL_TERM + term.text.length() * 2);
        }
    }

    public Iterable<Term> termsIterable() {
        return new Iterable<Term>(){

            @Override
            public Iterator<Term> iterator() {
                return BufferedDeletes.this.terms.keySet().iterator();
            }
        };
    }

    public Iterable<BufferedDeletesStream.QueryAndLimit> queriesIterable() {
        return new Iterable<BufferedDeletesStream.QueryAndLimit>(){

            @Override
            public Iterator<BufferedDeletesStream.QueryAndLimit> iterator() {
                return new Iterator<BufferedDeletesStream.QueryAndLimit>(){
                    private final Iterator<Map.Entry<Query, Integer>> iter;
                    {
                        this.iter = BufferedDeletes.this.queries.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public BufferedDeletesStream.QueryAndLimit next() {
                        Map.Entry<Query, Integer> ent = this.iter.next();
                        return new BufferedDeletesStream.QueryAndLimit(ent.getKey(), ent.getValue());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    void clear() {
        this.terms.clear();
        this.queries.clear();
        this.docIDs.clear();
        this.numTermDeletes.set(0);
        this.bytesUsed.set(0L);
    }

    void clearDocIDs() {
        this.bytesUsed.addAndGet(-this.docIDs.size() * BYTES_PER_DEL_DOCID);
        this.docIDs.clear();
    }

    boolean any() {
        return this.terms.size() > 0 || this.docIDs.size() > 0 || this.queries.size() > 0;
    }
}

