/*
 * Decompiled with CFR 0.152.
 */
package com.datomic.lucene.store;

import com.datomic.lucene.index.IndexFileNameFilter;
import com.datomic.lucene.store.AlreadyClosedException;
import com.datomic.lucene.store.IndexInput;
import com.datomic.lucene.store.IndexOutput;
import com.datomic.lucene.store.Lock;
import com.datomic.lucene.store.LockFactory;
import com.datomic.lucene.util.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Directory
implements Closeable {
    protected volatile boolean isOpen = true;
    protected LockFactory lockFactory;

    public abstract String[] listAll() throws IOException;

    public abstract boolean fileExists(String var1) throws IOException;

    public abstract long fileModified(String var1) throws IOException;

    @Deprecated
    public abstract void touchFile(String var1) throws IOException;

    public abstract void deleteFile(String var1) throws IOException;

    public abstract long fileLength(String var1) throws IOException;

    public abstract IndexOutput createOutput(String var1) throws IOException;

    @Deprecated
    public void sync(String name) throws IOException {
    }

    public void sync(Collection<String> names) throws IOException {
        for (String name : names) {
            this.sync(name);
        }
    }

    public abstract IndexInput openInput(String var1) throws IOException;

    public IndexInput openInput(String name, int bufferSize) throws IOException {
        return this.openInput(name);
    }

    public Lock makeLock(String name) {
        return this.lockFactory.makeLock(name);
    }

    public void clearLock(String name) throws IOException {
        if (this.lockFactory != null) {
            this.lockFactory.clearLock(name);
        }
    }

    @Override
    public abstract void close() throws IOException;

    public void setLockFactory(LockFactory lockFactory) throws IOException {
        assert (lockFactory != null);
        this.lockFactory = lockFactory;
        lockFactory.setLockPrefix(this.getLockID());
    }

    public LockFactory getLockFactory() {
        return this.lockFactory;
    }

    public String getLockID() {
        return this.toString();
    }

    public String toString() {
        return super.toString() + " lockFactory=" + this.getLockFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(Directory to, String src, String dest) throws IOException {
        IndexOutput os = to.createOutput(dest);
        IndexInput is = this.openInput(src);
        IOException priorException = null;
        try {
            is.copyBytes(os, is.length());
        }
        catch (IOException ioe) {
            try {
                priorException = ioe;
            }
            catch (Throwable throwable) {
                IOUtils.closeSafely(priorException, os, is);
                throw throwable;
            }
            IOUtils.closeSafely(priorException, os, is);
        }
        IOUtils.closeSafely(priorException, os, is);
    }

    @Deprecated
    public static void copy(Directory src, Directory dest, boolean closeDirSrc) throws IOException {
        IndexFileNameFilter filter = IndexFileNameFilter.getFilter();
        for (String file : src.listAll()) {
            if (!filter.accept(null, file)) continue;
            src.copy(dest, file, file);
        }
        if (closeDirSrc) {
            src.close();
        }
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        if (!this.isOpen) {
            throw new AlreadyClosedException("this Directory is closed");
        }
    }
}

