/*
 * Decompiled with CFR 0.152.
 */
package com.datomic.lucene.util.fst;

import com.datomic.lucene.util.BytesRef;
import com.datomic.lucene.util.fst.FST;
import com.datomic.lucene.util.fst.FSTEnum;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BytesRefFSTEnum<T>
extends FSTEnum<T> {
    private final BytesRef current = new BytesRef(10);
    private final InputOutput<T> result = new InputOutput();
    private BytesRef target;

    public BytesRefFSTEnum(FST<T> fst) {
        super(fst);
        this.result.input = this.current;
        this.current.offset = 1;
    }

    public InputOutput<T> current() {
        return this.result;
    }

    public InputOutput<T> next() throws IOException {
        this.doNext();
        return this.setResult();
    }

    public InputOutput<T> seekCeil(BytesRef target) throws IOException {
        this.target = target;
        this.targetLength = target.length;
        super.doSeekCeil();
        return this.setResult();
    }

    public InputOutput<T> seekFloor(BytesRef target) throws IOException {
        this.target = target;
        this.targetLength = target.length;
        super.doSeekFloor();
        return this.setResult();
    }

    @Override
    protected int getTargetLabel() {
        if (this.upto - 1 == this.target.length) {
            return -1;
        }
        return this.target.bytes[this.target.offset + this.upto - 1] & 0xFF;
    }

    @Override
    protected int getCurrentLabel() {
        return this.current.bytes[this.upto] & 0xFF;
    }

    @Override
    protected void setCurrentLabel(int label) {
        this.current.bytes[this.upto] = (byte)label;
    }

    @Override
    protected void grow() {
        this.current.grow(this.upto + 1);
    }

    private InputOutput<T> setResult() {
        if (this.upto == 0) {
            return null;
        }
        this.current.length = this.upto - 1;
        this.result.output = this.output[this.upto];
        return this.result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InputOutput<T> {
        public BytesRef input;
        public T output;
    }
}

