/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached;

import datomic.spy.memcached.ClientMode;
import datomic.spy.memcached.ConnectionFactory;
import datomic.spy.memcached.DefaultConnectionFactory;
import datomic.spy.memcached.HashAlgorithm;
import datomic.spy.memcached.MemcachedNode;
import datomic.spy.memcached.OperationFactory;
import datomic.spy.memcached.protocol.binary.BinaryMemcachedNodeImpl;
import datomic.spy.memcached.protocol.binary.BinaryOperationFactory;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;

public class BinaryConnectionFactory
extends DefaultConnectionFactory {
    public BinaryConnectionFactory() {
    }

    public BinaryConnectionFactory(ClientMode clientMode) {
        super(clientMode);
    }

    public BinaryConnectionFactory(int len, int bufSize) {
        super(ClientMode.Dynamic, len, bufSize);
    }

    public BinaryConnectionFactory(ClientMode clientMode, int len, int bufSize) {
        super(clientMode, len, bufSize);
    }

    public BinaryConnectionFactory(int len, int bufSize, HashAlgorithm hash) {
        super(ClientMode.Dynamic, len, bufSize, hash);
    }

    public BinaryConnectionFactory(ClientMode clientMode, int len, int bufSize, HashAlgorithm hash) {
        super(clientMode, len, bufSize, hash);
    }

    @Override
    public MemcachedNode createMemcachedNode(SocketAddress sa, SocketChannel c, int bufSize) {
        boolean doAuth = false;
        if (this.getAuthDescriptor() != null) {
            doAuth = true;
        }
        return new BinaryMemcachedNodeImpl(sa, c, bufSize, this.createReadOperationQueue(), this.createWriteOperationQueue(), this.createOperationQueue(), (Long)this.getOpQueueMaxBlockTime(), doAuth, this.getOperationTimeout(), this.getConfigOperationTimeout(), this.getAuthWaitTime(), (ConnectionFactory)this);
    }

    @Override
    public OperationFactory getOperationFactory() {
        return new BinaryOperationFactory();
    }

    @Override
    protected String getName() {
        return "BinaryConnectionFactory";
    }
}

