/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached;

import datomic.spy.memcached.AddrUtil;
import datomic.spy.memcached.MemcachedClient;
import datomic.spy.memcached.OperationNotSupportedException;
import datomic.spy.memcached.OperationTimeoutException;
import datomic.spy.memcached.compat.SpyThread;
import datomic.spy.memcached.config.ClusterConfiguration;
import datomic.spy.memcached.config.ClusterConfigurationObserver;
import datomic.spy.memcached.config.NodeEndPoint;
import datomic.spy.memcached.ops.ConfigurationType;
import datomic.spy.memcached.transcoders.SerializingTranscoder;
import datomic.spy.memcached.transcoders.Transcoder;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ConfigurationPoller
extends SpyThread {
    private static final long INITIAL_DELAY = 5000L;
    public static final long DEFAULT_POLL_INTERVAL = 60000L;
    private static final int MAX_RETRY_ATTEMPT = 3;
    private static final long RETRY_INTERVAL = 500L;
    private final MemcachedClient client;
    private List<ClusterConfigurationObserver> clusterConfigObservers = new ArrayList<ClusterConfigurationObserver>();
    private String currentClusterConfigResponse;
    private ClusterConfiguration currentClusterConfiguration;
    private Transcoder<Object> configTranscoder = new SerializingTranscoder();
    private int currentIndex = 0;
    private Date date = new Date();
    private long lastSuccessfulPoll = this.date.getTime();
    private int pollingErrorCount = 0;
    private ScheduledThreadPoolExecutor scheduledExecutor;

    public ConfigurationPoller(MemcachedClient client) {
        this(client, 60000L, false);
    }

    public ConfigurationPoller(MemcachedClient client, long pollingInterval, final boolean useDaemonThreads) {
        this.client = client;
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setDaemon(useDaemonThreads);
                return thread;
            }
        });
        this.setDaemon(useDaemonThreads);
        List<NodeEndPoint> emptyList = Collections.emptyList();
        this.currentClusterConfiguration = new ClusterConfiguration(-1L, emptyList);
        this.scheduledExecutor.scheduleAtFixedRate(this, 5000L, pollingInterval, TimeUnit.MILLISECONDS);
    }

    public void subscribeForClusterConfiguration(ClusterConfigurationObserver observer) {
        this.clusterConfigObservers.add(observer);
    }

    @Override
    public void run() {
        try {
            this.getLogger().info("Starting configuration poller.");
            String newConfigResponse = null;
            NodeEndPoint endpointToGetConfig = null;
            Collection<NodeEndPoint> endpoints = this.client.getAvailableNodeEndPoints();
            if (endpoints.isEmpty()) {
                endpoints = this.client.getAllNodeEndPoints();
            }
            this.currentIndex = (this.currentIndex + 1) % endpoints.size();
            Iterator<NodeEndPoint> iterator = endpoints.iterator();
            for (int i = 0; i < this.currentIndex; ++i) {
                iterator.next();
            }
            endpointToGetConfig = iterator.next();
            InetSocketAddress socketAddressToGetConfig = endpointToGetConfig.getInetSocketAddress();
            this.getLogger().info("Endpoint to use for configuration access in this poll " + endpointToGetConfig.toString());
            int retryCount = 0;
            while (retryCount < 3 || !this.client.isConfigurationInitialized()) {
                try {
                    if (this.client.isConfigurationProtocolSupported()) {
                        try {
                            newConfigResponse = (String)this.client.getConfig(socketAddressToGetConfig, ConfigurationType.CLUSTER, this.configTranscoder);
                            if (newConfigResponse != null && !newConfigResponse.trim().isEmpty() || (newConfigResponse = (String)this.client.get(socketAddressToGetConfig, ConfigurationType.CLUSTER.getValueWithNameSpace(), this.configTranscoder)) == null || newConfigResponse.trim().isEmpty()) break;
                            this.client.setIsConfigurationProtocolSupported(false);
                            break;
                        }
                        catch (OperationNotSupportedException e) {
                            this.client.setIsConfigurationProtocolSupported(false);
                            continue;
                        }
                    }
                    newConfigResponse = (String)this.client.get(socketAddressToGetConfig, ConfigurationType.CLUSTER.getValueWithNameSpace(), this.configTranscoder);
                    break;
                }
                catch (OperationTimeoutException e) {
                    ++retryCount;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        this.getLogger().warn((Object)"Poller thread interrupted during the retry interval for config call. Continue with retry.", ex);
                    }
                    if (retryCount >= 3 && this.client.isConfigurationInitialized()) {
                        this.getLogger().warn((Object)"Max retry attempt reached for config call. Stopping the current poll cycle.", e);
                        return;
                    }
                    if (retryCount == 2) {
                        socketAddressToGetConfig = this.client.getConfigurationNode().getInetSocketAddress();
                        continue;
                    }
                    socketAddressToGetConfig = endpointToGetConfig.getInetSocketAddress(true);
                }
            }
            if (newConfigResponse == null) {
                this.getLogger().warn("The configuration is null in the server " + endpointToGetConfig.getHostName());
                this.trackPollingError();
                return;
            }
            this.getLogger().debug("Retrieved configuration value:" + newConfigResponse);
            if (newConfigResponse != null && !newConfigResponse.equals(this.currentClusterConfigResponse)) {
                ClusterConfiguration newClusterConfiguration = AddrUtil.parseClusterTypeConfiguration(newConfigResponse);
                this.getLogger().warn("Change in configuration - Existing configuration: " + this.currentClusterConfiguration + "\n New configuration:" + newClusterConfiguration);
                if (newClusterConfiguration.getConfigVersion() > this.currentClusterConfiguration.getConfigVersion()) {
                    this.currentClusterConfigResponse = newConfigResponse;
                    this.currentClusterConfiguration = newClusterConfiguration;
                    for (ClusterConfigurationObserver observer : this.clusterConfigObservers) {
                        this.getLogger().info("Notifying observers about configuration change.");
                        observer.notifyUpdate(newClusterConfiguration);
                    }
                    if (!this.client.isConfigurationInitialized()) {
                        this.client.setIsConfigurtionInitialized(true);
                    }
                } else if (newClusterConfiguration.getConfigVersion() < this.currentClusterConfiguration.getConfigVersion()) {
                    this.getLogger().info("Ignoring stale configuration - Existing configuration: " + this.currentClusterConfigResponse + "\n Stale configuration:" + newConfigResponse);
                    this.trackPollingError();
                    return;
                }
            }
            this.pollingErrorCount = 0;
            this.lastSuccessfulPoll = this.date.getTime();
        }
        catch (Exception e) {
            this.getLogger().error((Object)("Error encountered in the poller. Current cluster configuration: " + this.currentClusterConfigResponse), e);
            this.trackPollingError();
        }
    }

    private void trackPollingError() {
        ++this.pollingErrorCount;
        this.getLogger().warn("Number of consecutive poller errors is " + Long.toString(this.pollingErrorCount) + ". Number of minutes since the last successful polling is " + Long.toString(this.date.getTime() - this.lastSuccessfulPoll));
    }

    public void shutdown() {
        this.scheduledExecutor.shutdownNow();
    }
}

