/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached;

import datomic.spy.memcached.HashAlgorithm;
import datomic.spy.memcached.MemcachedNode;
import datomic.spy.memcached.compat.SpyObject;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

class KetamaIterator
extends SpyObject
implements Iterator<MemcachedNode> {
    private final String key;
    private long hashVal;
    private int remainingTries;
    private int numTries = 0;
    private final HashAlgorithm hashAlg;
    private final TreeMap<Long, MemcachedNode> ketamaNodes;

    protected KetamaIterator(String k, int t, TreeMap<Long, MemcachedNode> ketamaNodes, HashAlgorithm hashAlg) {
        this.ketamaNodes = ketamaNodes;
        this.hashAlg = hashAlg;
        this.hashVal = hashAlg.hash(k);
        this.remainingTries = t;
        this.key = k;
    }

    private void nextHash() {
        long tmpKey = this.hashAlg.hash(this.numTries++ + this.key);
        this.hashVal += (long)((int)(tmpKey ^ tmpKey >>> 32));
        this.hashVal &= 0xFFFFFFFFL;
        --this.remainingTries;
    }

    @Override
    public boolean hasNext() {
        return this.remainingTries > 0;
    }

    @Override
    public MemcachedNode next() {
        try {
            MemcachedNode memcachedNode = this.getNodeForKey(this.hashVal);
            return memcachedNode;
        }
        finally {
            this.nextHash();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }

    private MemcachedNode getNodeForKey(long hash) {
        if (!this.ketamaNodes.containsKey(hash)) {
            SortedMap<Long, MemcachedNode> tailMap = this.ketamaNodes.tailMap(hash);
            hash = tailMap.isEmpty() ? this.ketamaNodes.firstKey().longValue() : tailMap.firstKey().longValue();
        }
        MemcachedNode rv = this.ketamaNodes.get(hash);
        return rv;
    }
}

