/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.internal;

import datomic.spy.memcached.compat.SpyObject;
import datomic.spy.memcached.internal.GenericCompletionListener;
import datomic.spy.memcached.internal.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public abstract class AbstractListenableFuture<T, L extends GenericCompletionListener>
extends SpyObject
implements ListenableFuture<T, L> {
    private final ExecutorService service;
    private List<GenericCompletionListener<? extends Future<T>>> listeners;

    protected AbstractListenableFuture(ExecutorService executor) {
        this.service = executor;
        this.listeners = new ArrayList<GenericCompletionListener<? extends Future<T>>>();
    }

    protected ExecutorService executor() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Future<T> addToListeners(GenericCompletionListener<? extends Future<T>> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener can't be null.");
        }
        AbstractListenableFuture abstractListenableFuture = this;
        synchronized (abstractListenableFuture) {
            this.listeners.add(listener);
        }
        if (this.isDone()) {
            this.notifyListeners();
        }
        return this;
    }

    protected void notifyListener(ExecutorService executor, final Future<?> future, final GenericCompletionListener listener) {
        executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    listener.onComplete(future);
                }
                catch (Throwable t) {
                    AbstractListenableFuture.this.getLogger().warn((Object)("Exception thrown wile executing " + listener.getClass().getName() + ".operationComplete()"), t);
                }
            }
        });
    }

    protected void notifyListeners() {
        this.notifyListeners(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(Future<?> future) {
        ArrayList<GenericCompletionListener<? extends Future<T>>> copy = new ArrayList<GenericCompletionListener<? extends Future<T>>>();
        AbstractListenableFuture abstractListenableFuture = this;
        synchronized (abstractListenableFuture) {
            copy.addAll(this.listeners);
            this.listeners = new ArrayList<GenericCompletionListener<? extends Future<T>>>();
        }
        for (GenericCompletionListener genericCompletionListener : copy) {
            this.notifyListener(this.executor(), future, genericCompletionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Future<T> removeFromListeners(GenericCompletionListener<? extends Future<T>> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener can't be null.");
        }
        if (!this.isDone()) {
            AbstractListenableFuture abstractListenableFuture = this;
            synchronized (abstractListenableFuture) {
                this.listeners.remove(listener);
            }
        }
        return this;
    }
}

