/*
 * Decompiled with CFR 0.152.
 */
package datomic.spy.memcached.protocol.ascii;

import datomic.spy.memcached.ops.OperationState;
import datomic.spy.memcached.ops.OperationStatus;
import datomic.spy.memcached.ops.StatsOperation;
import datomic.spy.memcached.ops.StatusCode;
import datomic.spy.memcached.protocol.BaseOperationImpl;
import datomic.spy.memcached.protocol.ascii.OperationImpl;
import java.nio.ByteBuffer;
import java.util.Arrays;

final class StatsOperationImpl
extends OperationImpl
implements StatsOperation {
    private static final OperationStatus END = new OperationStatus(true, "END", StatusCode.SUCCESS);
    private static final byte[] MSG = "stats\r\n".getBytes();
    private final byte[] msg;
    private final StatsOperation.Callback cb;

    public StatsOperationImpl(String arg, StatsOperation.Callback c) {
        super(c);
        this.cb = c;
        this.msg = arg == null ? MSG : ("stats " + arg + "\r\n").getBytes();
    }

    @Override
    public void handleLine(String line) {
        if (line.equals("END")) {
            this.cb.receivedStatus(END);
            this.transitionState(OperationState.COMPLETE);
        } else {
            String[] parts = line.split(" ", 3);
            assert (parts.length == 3);
            this.cb.gotStat(parts[1], parts[2]);
        }
    }

    @Override
    public void initialize() {
        this.setBuffer(ByteBuffer.wrap(this.msg));
    }

    @Override
    protected void wasCancelled() {
        this.cb.receivedStatus(BaseOperationImpl.CANCELLED);
    }

    public String toString() {
        return "Cmd: " + Arrays.toString(this.msg);
    }
}

