/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill;

import com.datorama.oss.timbermill.ClientHeartbeater;
import com.datorama.oss.timbermill.pipe.BlackHolePipe;
import com.datorama.oss.timbermill.pipe.EventOutputPipe;
import com.datorama.oss.timbermill.pipe.StatisticsCollectorOutputPipe;
import com.datorama.oss.timbermill.unit.ErrorEvent;
import com.datorama.oss.timbermill.unit.Event;
import com.datorama.oss.timbermill.unit.InfoEvent;
import com.datorama.oss.timbermill.unit.LogParams;
import com.datorama.oss.timbermill.unit.SpotEvent;
import com.datorama.oss.timbermill.unit.StartEvent;
import com.datorama.oss.timbermill.unit.SuccessEvent;
import com.datorama.oss.timbermill.unit.TaskStatus;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.function.Function;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EventLogger {
    private static final Logger LOG = LoggerFactory.getLogger(EventLogger.class);
    private static final String THREAD_NAME = "threadName";
    static final String STACK_TRACE = "stackTrace";
    private static Map<String, String> staticParams = new HashMap<String, String>();
    private static ThreadLocal<EventLogger> threadInstance = ThreadLocal.withInitial(() -> new EventLogger(new BlackHolePipe()));
    private static boolean isBootstrapped;
    private static String env;
    private Stack<String> taskIdStack = new Stack();
    private final EventOutputPipe eventOutputPipe;

    private EventLogger(EventOutputPipe eventOutputPipe) {
        this.eventOutputPipe = eventOutputPipe;
    }

    static void bootstrap(EventOutputPipe eventOutputPipe, boolean doHeartbeat, Map<String, String> staticParams, String environment) {
        try {
            env = environment;
            if (isBootstrapped) {
                LOG.warn("EventLogger is already bootstrapped, ignoring this bootstrap invocation. EventOutputPipe={}, ({})", (Object)eventOutputPipe, staticParams);
            } else {
                LOG.info("Timbermill 2 client 26072020");
                LOG.info("Bootstrapping EventLogger with params ({})", staticParams);
                isBootstrapped = true;
                StatisticsCollectorOutputPipe statsCollector = new StatisticsCollectorOutputPipe(eventOutputPipe);
                if (doHeartbeat) {
                    ClientHeartbeater heartbeater = new ClientHeartbeater(statsCollector, eventOutputPipe);
                    heartbeater.start();
                }
                EventLogger.staticParams.putAll(staticParams);
                threadInstance = ThreadLocal.withInitial(() -> new EventLogger(statsCollector));
            }
        }
        catch (Throwable t) {
            LOG.error("Was unable to bootstrap Timbermill", t);
        }
    }

    static void exit() {
        isBootstrapped = false;
    }

    static EventLogger get() {
        return threadInstance.get();
    }

    String startEvent(String name, LogParams logParams) {
        return this.startEvent(null, name, null, logParams, false, null);
    }

    String startEvent(String taskId, String name, String parentTaskId, LogParams logParams, boolean isOngoingTask, ZonedDateTime dateToDelete) {
        if (logParams == null) {
            logParams = LogParams.create();
        }
        try {
            this.addStaticParams(logParams);
            Event event = this.createStartEvent(taskId, logParams, parentTaskId, isOngoingTask, name, dateToDelete);
            return this.submitEvent(event);
        }
        catch (Throwable throwable) {
            LOG.error("Was unable to send event to Timbermill", throwable);
            return null;
        }
    }

    void successEvent(String taskId) {
        String latestTaskId;
        if (!this.taskIdStack.isEmpty() && (latestTaskId = this.taskIdStack.peek()) != null && latestTaskId.equals(taskId)) {
            this.successEvent();
        }
    }

    String successEvent() {
        return this.successEvent(null, LogParams.create());
    }

    String successEvent(String ongoingTaskId, LogParams logParams) {
        if (logParams == null) {
            logParams = LogParams.create();
        }
        try {
            Event event = this.createSuccessEvent(ongoingTaskId, logParams);
            return this.submitEvent(event);
        }
        catch (Throwable throwable) {
            LOG.error("Was unable to send event to Timbermill", throwable);
            return null;
        }
    }

    void endWithError(String taskId, Throwable t) {
        String latestTaskId;
        if (!this.taskIdStack.isEmpty() && (latestTaskId = this.taskIdStack.peek()) != null && latestTaskId.equals(taskId)) {
            this.endWithError(t);
        }
    }

    String endWithError(Throwable t) {
        return this.endWithError(t, null, null);
    }

    String endWithError(Throwable t, String ongoingTaskId, LogParams logParams) {
        if (logParams == null) {
            logParams = LogParams.create();
        }
        try {
            Event event = this.createErrorEvent(t, ongoingTaskId, logParams);
            return this.submitEvent(event);
        }
        catch (Throwable throwable) {
            LOG.error("Was unable to send event to Timbermill", throwable);
            return null;
        }
    }

    String spotEvent(String taskId, String name, String parentTaskId, LogParams logParams, TaskStatus status, ZonedDateTime dateToDelete) {
        if (logParams == null) {
            logParams = LogParams.create();
        }
        try {
            Event event = this.createSpotEvent(taskId, name, logParams, status, dateToDelete, parentTaskId);
            return this.submitEvent(event);
        }
        catch (Throwable throwable) {
            LOG.error("Was unable to send event to Timbermill", throwable);
            return null;
        }
    }

    String logParams(LogParams logParams) {
        return this.logParams(logParams, null);
    }

    String logParams(LogParams logParams, String ongoingTaskId) {
        if (logParams == null) {
            logParams = LogParams.create();
        }
        try {
            Event event = this.createInfoEvent(logParams, ongoingTaskId);
            return this.submitEvent(event);
        }
        catch (Throwable throwable) {
            LOG.error("Was unable to send event to Timbermill", throwable);
            return null;
        }
    }

    String getCurrentTaskId() {
        return this.taskIdStack.empty() ? null : this.taskIdStack.peek();
    }

    <T> Callable<T> wrapCallable(Callable<T> callable) {
        Stack<String> origTaskIdStack = this.taskIdStack;
        return () -> {
            EventLogger.get().taskIdStack = (Stack)origTaskIdStack.clone();
            Object call = callable.call();
            EventLogger.get().taskIdStack.clear();
            return call;
        };
    }

    <T, R> Function<T, R> wrapFunction(Function<T, R> function) {
        Stack<String> origTaskIdStack = this.taskIdStack;
        return t -> {
            EventLogger.get().taskIdStack = (Stack)origTaskIdStack.clone();
            Object call = function.apply(t);
            EventLogger.get().taskIdStack.clear();
            return call;
        };
    }

    void clearStack() {
        this.taskIdStack.clear();
    }

    void addIdToContext(String ongoingTaskId) {
        this.taskIdStack.push(ongoingTaskId);
    }

    void removeIdFromContext(String ongoingTaskId) {
        if (!this.taskIdStack.isEmpty() && this.taskIdStack.peek().equals(ongoingTaskId)) {
            this.taskIdStack.pop();
        } else {
            LOG.error("Task id: {} opened with TimberlogAdvanced.withContext() is not the top of the stack, probably failed to closed all the tasks in the scope", (Object)ongoingTaskId);
        }
    }

    private Event createStartEvent(String taskId, LogParams logParams, String parentTaskId, boolean isOngoingTask, String name, ZonedDateTime dateToDelete) {
        StartEvent event;
        if (!isOngoingTask) {
            if (parentTaskId == null) {
                parentTaskId = this.getParentIdFromStack();
            }
            event = new StartEvent(taskId, name, logParams, parentTaskId);
            this.taskIdStack.push(event.getTaskId());
        } else {
            event = new StartEvent(taskId, name, logParams, parentTaskId);
        }
        this.setDateToDelete(dateToDelete, event);
        return event;
    }

    private Event createSuccessEvent(String ongoingTaskId, LogParams logParams) {
        Event e = ongoingTaskId == null ? (this.taskIdStack.empty() ? this.getCorruptedEvent(logParams) : new SuccessEvent(this.taskIdStack.pop(), logParams)) : new SuccessEvent(ongoingTaskId, logParams);
        return e;
    }

    private Event createErrorEvent(Throwable t, String ongoingTaskId, LogParams logParams) {
        if (t != null) {
            try {
                logParams.text("exception", t + "\n" + ExceptionUtils.getStackTrace((Throwable)t));
            }
            catch (Exception e) {
                logParams.text("exception", t.getMessage());
            }
        }
        Event e = ongoingTaskId == null ? (this.taskIdStack.empty() ? this.getCorruptedEvent(logParams) : new ErrorEvent(this.taskIdStack.pop(), logParams)) : new ErrorEvent(ongoingTaskId, logParams);
        return e;
    }

    private Event createInfoEvent(LogParams logParams, String ongoingTaskId) {
        Event e = ongoingTaskId == null ? (this.taskIdStack.empty() ? this.getCorruptedEvent(logParams) : new InfoEvent(this.taskIdStack.peek(), logParams)) : new InfoEvent(ongoingTaskId, logParams);
        return e;
    }

    private Event createSpotEvent(String taskId, String name, LogParams logParams, TaskStatus status, ZonedDateTime dateToDelete, String parentTaskId) {
        if (logParams == null) {
            logParams = LogParams.create();
        }
        this.addStaticParams(logParams);
        if (parentTaskId == null) {
            parentTaskId = this.getParentIdFromStack();
        }
        SpotEvent spotEvent = new SpotEvent(taskId, name, parentTaskId, status, logParams);
        this.setDateToDelete(dateToDelete, spotEvent);
        return spotEvent;
    }

    private void setDateToDelete(ZonedDateTime dateToDelete, Event event) {
        if (dateToDelete != null) {
            ZonedDateTime now = ZonedDateTime.now();
            if (dateToDelete.isBefore(now)) {
                dateToDelete = now;
            }
            event.setDateToDelete(dateToDelete);
        }
    }

    private String getParentIdFromStack() {
        String parentId = null;
        if (!this.taskIdStack.isEmpty()) {
            parentId = this.taskIdStack.peek();
        }
        return parentId;
    }

    private void addStaticParams(@NotNull LogParams logParams) {
        logParams.string(THREAD_NAME, Thread.currentThread().getName());
        logParams.string(staticParams);
    }

    private Event getCorruptedEvent(@NotNull LogParams logParams) {
        String stackTrace = EventLogger.getStackTraceString();
        this.addStaticParams(logParams);
        logParams.text(STACK_TRACE, stackTrace);
        return this.createSpotEvent(null, "LogWithoutContext", logParams, TaskStatus.CORRUPTED, null, null);
    }

    static String getStackTraceString() {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (StackTraceElement stackTraceElement : stackTrace = Arrays.copyOfRange(stackTrace, 5, 10)) {
            sb.append(stackTraceElement).append('\n');
        }
        return sb.toString();
    }

    private String submitEvent(Event event) {
        event.setEnv(env);
        this.eventOutputPipe.send(event);
        return event.getTaskId();
    }
}

