/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill.unit;

import com.datorama.oss.timbermill.common.ZonedDateTimeJacksonDeserializer;
import com.datorama.oss.timbermill.common.ZonedDateTimeJacksonSerializer;
import com.datorama.oss.timbermill.unit.ErrorEvent;
import com.datorama.oss.timbermill.unit.InfoEvent;
import com.datorama.oss.timbermill.unit.LogParams;
import com.datorama.oss.timbermill.unit.SpotEvent;
import com.datorama.oss.timbermill.unit.StartEvent;
import com.datorama.oss.timbermill.unit.SuccessEvent;
import com.datorama.oss.timbermill.unit.TaskStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@JsonSubTypes(value={@JsonSubTypes.Type(value=StartEvent.class, name="StartEvent"), @JsonSubTypes.Type(value=InfoEvent.class, name="InfoEvent"), @JsonSubTypes.Type(value=SuccessEvent.class, name="SuccessEvent"), @JsonSubTypes.Type(value=ErrorEvent.class, name="ErrorEvent"), @JsonSubTypes.Type(value=SpotEvent.class, name="SpotEvent")})
public abstract class Event
implements Serializable {
    public static final String EVENT_ID_DELIMITER = "___";
    protected String taskId;
    private static final Logger LOG = LoggerFactory.getLogger(Event.class);
    static final long serialVersionUID = 20201201L;
    @JsonDeserialize(using=ZonedDateTimeJacksonDeserializer.class)
    @JsonSerialize(using=ZonedDateTimeJacksonSerializer.class)
    protected ZonedDateTime time;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    String primaryId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String parentId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Map<String, String> strings;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, String> text;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, String> context;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, Number> metrics;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> parentsPath;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String env;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean orphan;
    @JsonDeserialize(using=ZonedDateTimeJacksonDeserializer.class)
    @JsonSerialize(using=ZonedDateTimeJacksonSerializer.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected ZonedDateTime dateToDelete;

    public Event() {
    }

    Event(String taskId, String name, @NotNull LogParams logParams, String parentId) {
        if (taskId == null) {
            taskId = Event.generateTaskId(name);
        }
        this.taskId = taskId;
        this.parentId = parentId;
        this.time = ZonedDateTime.now();
        this.name = name;
        this.strings = logParams.getStrings();
        this.text = logParams.getTexts();
        this.context = logParams.getContext();
        this.metrics = logParams.getMetrics();
    }

    public String getTaskId() {
        return this.taskId;
    }

    void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getPrimaryId() {
        return this.primaryId;
    }

    public void setPrimaryId(String primaryId) {
        this.primaryId = primaryId;
    }

    public Map<String, String> getStrings() {
        return this.strings;
    }

    public void setStrings(Map<String, String> strings) {
        this.strings = strings;
    }

    public Map<String, Number> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, Number> metrics) {
        this.metrics = metrics;
    }

    public Map<String, String> getText() {
        return this.text;
    }

    public void setText(Map<String, String> text) {
        this.text = text;
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public List<String> getParentsPath() {
        return this.parentsPath;
    }

    public void setParentsPath(List<String> parentsPath) {
        this.parentsPath = parentsPath;
    }

    public ZonedDateTime getTime() {
        return this.time;
    }

    public void setTime(ZonedDateTime time) {
        this.time = time;
    }

    @JsonIgnore
    public ZonedDateTime getStartTime() {
        return null;
    }

    @JsonIgnore
    public ZonedDateTime getEndTime() {
        return null;
    }

    public String toString() {
        return "Event{id='" + this.taskId + '\'' + '}';
    }

    @JsonIgnore
    public abstract TaskStatus getStatusFromExistingStatus(TaskStatus var1, ZonedDateTime var2, ZonedDateTime var3, String var4, String var5);

    @JsonIgnore
    public boolean isStartEvent() {
        return false;
    }

    @JsonIgnore
    public boolean isAdoptedEvent() {
        return false;
    }

    @JsonIgnore
    public String getIndex() {
        return null;
    }

    @JsonIgnore
    public static String generateTaskId(String name) {
        String uuid = UUID.randomUUID().toString();
        uuid = uuid.replace("-", "_");
        return name + EVENT_ID_DELIMITER + uuid;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public Boolean isOrphan() {
        return this.orphan;
    }

    public void setOrphan(Boolean orphan) {
        this.orphan = orphan;
    }

    public void setDateToDelete(ZonedDateTime dateToDelete) {
        this.dateToDelete = dateToDelete;
    }

    ZonedDateTime getDateToDelete(long daysRotation) {
        return null;
    }

    @JsonIgnore
    public int estimatedSize() {
        int primaryIdLength = this.primaryId == null ? 0 : this.primaryId.length() + 15;
        int taskIdLength = this.taskId == null ? 0 : this.taskId.length() + 12;
        int nameLength = this.name == null ? 0 : this.name.length() + 10;
        int parentIdLength = this.parentId == null ? 0 : this.parentId.length() + 14;
        int envLength = this.env == null ? 0 : this.env.length() + 8;
        int stringsSize = this.strings == null ? 0 : this.getStringMapSize(this.strings) + 13;
        int textsSize = this.text == null ? 0 : this.getStringMapSize(this.text) + 10;
        int contextSize = this.context == null ? 0 : this.getStringMapSize(this.context) + 13;
        int metricsSize = this.metrics == null ? 0 : this.getNumberMapSize(this.metrics) + 13;
        int parentsPathSize = this.parentsPath == null ? 0 : this.stringListSize(this.parentsPath) + 14;
        int orphanSize = this.orphan == null ? 0 : 16;
        int dateToDeleteSize = this.dateToDelete == null ? 0 : 42;
        return this.getClass().getSimpleName().length() + 13 + 34 + primaryIdLength + taskIdLength + nameLength + parentIdLength + envLength + stringsSize + textsSize + contextSize + metricsSize + parentsPathSize + orphanSize + dateToDeleteSize;
    }

    @JsonIgnore
    private int stringListSize(List<String> strings) {
        int size = 0;
        for (String string : strings) {
            size += string.length() + 3;
        }
        return Math.max(size - 1, 0);
    }

    @JsonIgnore
    private int getStringMapSize(Map<String, String> map) {
        int size = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            size += entry.getKey().length() + entry.getValue().length() + 6;
        }
        return Math.max(size - 1, 0);
    }

    @JsonIgnore
    private int getNumberMapSize(Map<String, Number> map) {
        int size = 0;
        for (Map.Entry<String, Number> entry : map.entrySet()) {
            if (entry == null) continue;
            if (entry.getKey() != null) {
                size += entry.getKey().length();
            }
            if (entry.getValue() == null) continue;
            size = (int)((double)size + (Math.log10(entry.getValue().doubleValue()) + 1.0 + 4.0));
        }
        return Math.max(size - 1, 0);
    }

    @JsonIgnore
    public void trimAllStrings() {
        this.strings = this.getTrimmedLongValues(this.strings, "string");
        this.context = this.getTrimmedLongValues(this.context, "ctx");
        this.text = this.getTrimmedLongValues(this.text, "text");
        this.metrics = this.removeNaNs();
    }

    @JsonIgnore
    private Map<String, Number> removeNaNs() {
        if (this.metrics != null) {
            HashMap newMetrics = Maps.newHashMap();
            for (Map.Entry<String, Number> entry : this.metrics.entrySet()) {
                String key = entry.getKey();
                Number value = entry.getValue();
                if (value == null) continue;
                if (Double.isNaN(value.doubleValue()) || Float.isNaN(value.floatValue())) {
                    newMetrics.put(key, 0);
                    continue;
                }
                newMetrics.put(key, value);
            }
            return newMetrics;
        }
        return null;
    }

    @JsonIgnore
    private Map<String, String> getTrimmedLongValues(Map<String, String> oldMap, String type) {
        if (oldMap != null) {
            HashMap<String, String> newMap = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : oldMap.entrySet()) {
                String key = entry.getKey();
                String value = this.trimIfNeededValue(type, key, entry.getValue());
                newMap.put(key, value);
            }
            return newMap;
        }
        return null;
    }

    @JsonIgnore
    private String trimIfNeededValue(String type, String key, String value) {
        value = type.equals("text") ? this.trimValue(type, key, value, 900000) : this.trimValue(type, key, value, 8000);
        return value;
    }

    @JsonIgnore
    private String trimValue(String type, String key, String value, int maxChars) {
        if (value != null && value.length() > maxChars) {
            LOG.debug("Value for key {}.{} is too large, trimmed to {} chars. Value starts with: {}", new Object[]{type, key, maxChars, value.substring(0, 100)});
            value = value.substring(0, maxChars);
        }
        return value;
    }

    @JsonIgnore
    public void replaceAllFieldsWithDots() {
        this.context = this.replaceFieldWithDots(this.context);
        this.strings = this.replaceFieldWithDots(this.strings);
        this.text = this.replaceFieldWithDots(this.text);
        this.metrics = this.replaceFieldWithDots(this.metrics);
    }

    @JsonIgnore
    private <T> HashMap<String, T> replaceFieldWithDots(Map<String, T> field) {
        HashMap<String, T> newMap = new HashMap<String, T>();
        if (field != null) {
            for (Map.Entry<String, T> entry : field.entrySet()) {
                String key = entry.getKey();
                newMap.put(key.replace(".", "_"), field.get(key));
            }
        }
        return newMap;
    }

    @JsonIgnore
    public void fixErrors() {
        if (this.taskId != null && this.taskId.endsWith("_timbermill2_timbermill2")) {
            this.taskId = this.taskId.replace("_timbermill2_timbermill2", "");
        }
        if (this.taskId != null && this.taskId.endsWith("_timbermill2")) {
            this.taskId = this.taskId.replace("_timbermill2", "");
        }
        if (this.parentId != null && this.parentId.endsWith("_timbermill2_timbermill2")) {
            this.parentId = this.parentId.replace("_timbermill2_timbermill2", "");
        }
        if (this.parentId != null && this.parentId.endsWith("_timbermill2")) {
            this.parentId = this.parentId.replace("_timbermill2", "");
        }
    }
}

