/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill.unit;

import com.datorama.oss.timbermill.unit.Event;
import com.datorama.oss.timbermill.unit.LogParams;
import com.datorama.oss.timbermill.unit.TaskStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Maps;
import java.time.ZonedDateTime;
import javax.validation.constraints.NotNull;

public class StartEvent
extends Event {
    private static final String ALREADY_STARTED_DIFFERENT_PARENT = "ALREADY_STARTED_DIFFERENT_PARENT";
    private static final String ALREADY_STARTED_DIFFERENT_NAME = "ALREADY_STARTED_DIFFERENT_NAME";
    public static final String ALREADY_STARTED_DIFFERENT_START_TIME = "ALREADY_STARTED_DIFFERENT_START_TIME";
    private static final long serialVersionUID = 20201201L;

    public StartEvent() {
    }

    public StartEvent(String taskId, String name, @NotNull LogParams logParams, String parentId) {
        super(taskId, name, logParams, parentId);
    }

    @Override
    @JsonIgnore
    public TaskStatus getStatusFromExistingStatus(TaskStatus taskStatus, ZonedDateTime taskStartTime, ZonedDateTime taskEndTime, String taskParentId, String taskName) {
        if (taskStatus == TaskStatus.UNTERMINATED || taskStatus == TaskStatus.SUCCESS || taskStatus == TaskStatus.ERROR) {
            return this.handleAlreadyStarted(taskStartTime, taskName, taskParentId, taskStatus);
        }
        if (taskStatus == TaskStatus.PARTIAL_SUCCESS) {
            return TaskStatus.SUCCESS;
        }
        if (taskStatus == TaskStatus.PARTIAL_ERROR) {
            return TaskStatus.ERROR;
        }
        if (taskStatus == TaskStatus.CORRUPTED) {
            return TaskStatus.CORRUPTED;
        }
        return TaskStatus.UNTERMINATED;
    }

    private TaskStatus handleAlreadyStarted(ZonedDateTime taskStartTime, String taskName, String taskParentId, TaskStatus taskStatus) {
        if (this.strings == null) {
            this.strings = Maps.newHashMap();
        }
        if (taskStartTime != null && !taskStartTime.equals(this.time)) {
            this.strings.put("corruptedReason", ALREADY_STARTED_DIFFERENT_START_TIME);
            return TaskStatus.CORRUPTED;
        }
        if (taskName != null && !taskName.equals(this.name)) {
            this.strings.put("corruptedReason", ALREADY_STARTED_DIFFERENT_NAME);
            return TaskStatus.CORRUPTED;
        }
        if (taskParentId != null && !taskParentId.equals(this.parentId)) {
            this.strings.put("corruptedReason", ALREADY_STARTED_DIFFERENT_PARENT);
            return TaskStatus.CORRUPTED;
        }
        return taskStatus;
    }

    @Override
    @JsonIgnore
    public boolean isStartEvent() {
        return true;
    }

    @Override
    @JsonIgnore
    public ZonedDateTime getStartTime() {
        return this.time;
    }
}

