/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill;

import com.datorama.oss.timbermill.EventLogger;
import com.datorama.oss.timbermill.pipe.EventOutputPipe;
import com.datorama.oss.timbermill.pipe.StatisticsCollectorOutputPipe;
import com.datorama.oss.timbermill.unit.LogParams;
import com.datorama.oss.timbermill.unit.TaskStatus;

public class ClientHeartbeater {
    private static final int TIME_TO_SLEEP = 60000;
    public static final String SUBMIT_AMOUNT = "submitAmount";
    public static final String AVG_SUBMIT_DURATION = "avgSubmitDuration";
    public static final String MAX_SUBMIT_DURATION = "maxSubmitDuration";
    public static final String OUTPUT_BUFFER_SIZE = "outputBufferSize";
    private final StatisticsCollectorOutputPipe statsCollector;
    private final EventOutputPipe eop;

    ClientHeartbeater(StatisticsCollectorOutputPipe statsCollector, EventOutputPipe eop) {
        this.statsCollector = statsCollector;
        this.eop = eop;
    }

    void start() {
        Thread heartbeatThread = new Thread(() -> {
            while (true) {
                LogParams logParams = LogParams.create().metric(SUBMIT_AMOUNT, this.statsCollector.getEventsAmount()).metric(AVG_SUBMIT_DURATION, this.statsCollector.getAvgSubmitDuration()).metric(MAX_SUBMIT_DURATION, this.statsCollector.getMaxSubmitDuration());
                this.statsCollector.initCounters();
                if (this.eop != null) {
                    logParams.metric(OUTPUT_BUFFER_SIZE, this.eop.getCurrentBufferSize());
                }
                EventLogger.get().spotEvent(null, "metadata_timbermill_client_heartbeat", null, logParams, TaskStatus.SUCCESS, null);
                try {
                    Thread.sleep(60000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        });
        heartbeatThread.setName("timbermill-heartbeat-thread");
        heartbeatThread.setDaemon(true);
        heartbeatThread.start();
    }
}

