/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill.annotation;

import com.datorama.oss.timbermill.TimberLogger;
import com.datorama.oss.timbermill.annotation.TimberLogTask;
import com.datorama.oss.timbermill.unit.LogParams;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.CodeSignature;

@Aspect
public class TimberLogAspect {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ TimberLogAspect ajc$perSingletonInstance;

    @Around(value="(execution(* *(..)) || execution(*.new(..))) && @annotation(timberLogAnnotation)")
    public Object timberLog(ProceedingJoinPoint pjp, TimberLogTask timberLogAnnotation) throws Throwable {
        LogParams logParams = null;
        if (timberLogAnnotation.logParameters()) {
            logParams = this.getLogParamsForMethodParams(pjp, logParams);
        }
        TimberLogger.start(timberLogAnnotation.name(), logParams);
        try {
            Object obj = pjp.proceed();
            TimberLogger.success();
            return obj;
        }
        catch (Exception e) {
            TimberLogger.error(e);
            throw e;
        }
    }

    private LogParams getLogParamsForMethodParams(ProceedingJoinPoint pjp, LogParams logParams) {
        Signature signature = pjp.getSignature();
        if (signature instanceof CodeSignature) {
            CodeSignature codeSignature = (CodeSignature)signature;
            String[] parameterNames = codeSignature.getParameterNames();
            Object[] parameterValues = pjp.getArgs();
            if (parameterNames != null && parameterValues != null && parameterNames.length == parameterValues.length) {
                logParams = LogParams.create();
                int i = 0;
                while (i < parameterNames.length) {
                    logParams.string(parameterNames[i], String.valueOf(parameterValues[i]));
                    ++i;
                }
            }
        }
        return logParams;
    }

    public static TimberLogAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.datorama.oss.timbermill.annotation.TimberLogAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            TimberLogAspect.ajc$perSingletonInstance = new TimberLogAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

