/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill.common;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class ZonedDateTimeConverter
implements JsonSerializer<ZonedDateTime>,
JsonDeserializer<ZonedDateTime> {
    public JsonElement serialize(ZonedDateTime t, Type type, JsonSerializationContext jsonSerializationContext) {
        return new JsonPrimitive(t.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
    }

    public ZonedDateTime deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        return ZonedDateTime.parse(jsonElement.getAsString(), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }
}

