/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill.pipe;

import com.datorama.oss.timbermill.pipe.EventOutputPipe;
import com.datorama.oss.timbermill.unit.Event;
import java.util.concurrent.atomic.AtomicLong;

public class StatisticsCollectorOutputPipe
implements EventOutputPipe {
    private final EventOutputPipe delegate;
    private final AtomicLong eventsAmount = new AtomicLong(0L);
    private final AtomicLong totalSubmitDuration = new AtomicLong(0L);
    private final AtomicLong maxSubmitDuration = new AtomicLong(0L);

    public StatisticsCollectorOutputPipe(EventOutputPipe delegate) {
        this.delegate = delegate;
    }

    @Override
    public void send(Event e) {
        long start = System.currentTimeMillis();
        this.delegate.send(e);
        long end = System.currentTimeMillis();
        this.updateCounters(end - start);
    }

    private void updateCounters(long duration) {
        this.totalSubmitDuration.addAndGet(duration);
        long curMax = this.maxSubmitDuration.get();
        if (duration > curMax) {
            this.maxSubmitDuration.compareAndSet(curMax, duration);
        }
        this.eventsAmount.incrementAndGet();
    }

    @Override
    public int getCurrentBufferSize() {
        return this.delegate.getCurrentBufferSize();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public void initCounters() {
        this.eventsAmount.set(0L);
        this.totalSubmitDuration.set(0L);
        this.maxSubmitDuration.set(0L);
    }

    public long getEventsAmount() {
        return this.eventsAmount.get();
    }

    public long getMaxSubmitDuration() {
        return this.maxSubmitDuration.get();
    }

    private long getTotalSubmitDuration() {
        return this.totalSubmitDuration.get();
    }

    public double getAvgSubmitDuration() {
        if (this.getEventsAmount() > 0L) {
            return (double)this.getTotalSubmitDuration() / (double)this.getEventsAmount();
        }
        return 0.0;
    }

    public String toString() {
        return String.format("eventsAmount:%d, avgSubmitDuration: %f, maxSubmitDuration:%d", this.getEventsAmount(), this.getAvgSubmitDuration(), this.getMaxSubmitDuration());
    }
}

