/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill.unit;

import com.datorama.oss.timbermill.unit.Event;
import com.datorama.oss.timbermill.unit.LogParams;
import com.datorama.oss.timbermill.unit.SuccessEvent;
import com.datorama.oss.timbermill.unit.TaskStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.ZonedDateTime;
import javax.validation.constraints.NotNull;

public class ErrorEvent
extends Event {
    public ErrorEvent() {
    }

    public ErrorEvent(String taskId, @NotNull LogParams logParams) {
        super(taskId, null, logParams, null);
    }

    @Override
    public ZonedDateTime getEndTime() {
        return this.time;
    }

    @Override
    @JsonIgnore
    public TaskStatus getStatusFromExistingStatus(TaskStatus taskStatus, ZonedDateTime startTime, ZonedDateTime taskEndTime, String taskParentId, String taskName) {
        if (taskStatus == TaskStatus.UNTERMINATED) {
            return TaskStatus.ERROR;
        }
        if (taskStatus == TaskStatus.PARTIAL_SUCCESS || taskStatus == TaskStatus.SUCCESS) {
            return SuccessEvent.handleDifferentCloseStatus(this.strings);
        }
        if (taskStatus == TaskStatus.PARTIAL_ERROR || taskStatus == TaskStatus.ERROR) {
            return SuccessEvent.handleAlreadyClosed(this.time, taskEndTime, this.strings, taskStatus);
        }
        if (taskStatus == TaskStatus.CORRUPTED) {
            return TaskStatus.CORRUPTED;
        }
        return TaskStatus.PARTIAL_ERROR;
    }
}

