/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill.unit;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LogParams {
    private Map<String, String> strings = new HashMap<String, String>();
    private Map<String, String> texts = new HashMap<String, String>();
    private Map<String, Number> metrics = new HashMap<String, Number>();
    private Map<String, String> context = new HashMap<String, String>();
    private List<String> logs = new ArrayList<String>();

    public static LogParams create() {
        return new LogParams();
    }

    public LogParams logInfo(String s) {
        this.addToLogs(s, "INFO");
        return this;
    }

    public LogParams logWarn(String s) {
        this.addToLogs(s, "WARN");
        return this;
    }

    public LogParams logError(String s) {
        this.addToLogs(s, "Error");
        return this;
    }

    private void addToLogs(String log, String severity) {
        String date = ZonedDateTime.now().format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM));
        this.logs.add(String.format("[%s] [%s] - %s", date, severity, log));
    }

    public LogParams string(String key, Object value) {
        if (key != null) {
            this.strings.put(key, String.valueOf(value));
        }
        return this;
    }

    public LogParams string(Map<String, String> map) {
        map.forEach((key, value) -> {
            if (key != null) {
                this.strings.put((String)key, (String)value);
            }
        });
        return this;
    }

    public LogParams text(String key, String value) {
        if (key != null) {
            this.texts.put(key, value);
        }
        return this;
    }

    public LogParams text(Map<String, String> map) {
        map.forEach((key, value) -> {
            if (key != null) {
                this.texts.put((String)key, (String)value);
            }
        });
        return this;
    }

    public LogParams metric(String key, Number value) {
        if (key != null) {
            this.metrics.put(key, value);
        }
        return this;
    }

    public LogParams metric(Map<String, Number> map) {
        map.forEach((key, value) -> {
            if (key != null) {
                this.metrics.put((String)key, (Number)value);
            }
        });
        return this;
    }

    public LogParams context(String key, Object value) {
        if (key != null) {
            this.context.put(key, String.valueOf(value));
        }
        return this;
    }

    public LogParams context(Map<String, String> map) {
        map.forEach((key, value) -> {
            if (key != null) {
                this.context.put((String)key, (String)value);
            }
        });
        return this;
    }

    public Map<String, String> getStrings() {
        return this.strings;
    }

    public Map<String, Number> getMetrics() {
        return this.metrics;
    }

    public Map<String, String> getTexts() {
        return this.texts;
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public List<String> getLogs() {
        return this.logs;
    }
}

