/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill.unit;

import com.datorama.oss.timbermill.unit.Event;
import com.datorama.oss.timbermill.unit.LogParams;
import com.datorama.oss.timbermill.unit.TaskStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Maps;
import java.time.ZonedDateTime;
import java.util.Map;
import javax.validation.constraints.NotNull;

public class SuccessEvent
extends Event {
    public static final String ALREADY_CLOSED_DIFFERENT_CLOSE_TIME = "ALREADY_CLOSED_DIFFERENT_CLOSE_TIME";
    public static final String ALREADY_CLOSED_DIFFERENT_CLOSE_STATUS = "ALREADY_CLOSED_DIFFERENT_CLOSE_STATUS";

    public SuccessEvent() {
    }

    public SuccessEvent(String taskId, @NotNull LogParams logParams) {
        super(taskId, null, logParams, null);
    }

    @Override
    @JsonIgnore
    public ZonedDateTime getEndTime() {
        return this.time;
    }

    @Override
    @JsonIgnore
    public TaskStatus getStatusFromExistingStatus(TaskStatus taskStatus, ZonedDateTime taskStartTime, ZonedDateTime taskEndTime, String taskParentId, String taskName) {
        if (taskStatus == TaskStatus.UNTERMINATED) {
            return TaskStatus.SUCCESS;
        }
        if (taskStatus == TaskStatus.PARTIAL_ERROR || taskStatus == TaskStatus.ERROR) {
            return SuccessEvent.handleDifferentCloseStatus(this.strings);
        }
        if (taskStatus == TaskStatus.PARTIAL_SUCCESS || taskStatus == TaskStatus.SUCCESS) {
            return SuccessEvent.handleAlreadyClosed(this.time, taskEndTime, this.strings, taskStatus);
        }
        if (taskStatus == TaskStatus.CORRUPTED) {
            return TaskStatus.CORRUPTED;
        }
        return TaskStatus.PARTIAL_SUCCESS;
    }

    static TaskStatus handleDifferentCloseStatus(Map<String, String> strings) {
        if (strings == null) {
            strings = Maps.newHashMap();
        }
        strings.put("corruptedReason", ALREADY_CLOSED_DIFFERENT_CLOSE_STATUS);
        return TaskStatus.CORRUPTED;
    }

    static TaskStatus handleAlreadyClosed(ZonedDateTime eventTime, ZonedDateTime taskEndTime, Map<String, String> strings, TaskStatus taskStatus) {
        if (taskEndTime != null && !taskEndTime.equals(eventTime)) {
            if (strings == null) {
                strings = Maps.newHashMap();
            }
            strings.put("corruptedReason", ALREADY_CLOSED_DIFFERENT_CLOSE_TIME);
            return TaskStatus.CORRUPTED;
        }
        return taskStatus;
    }
}

