/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill;

import com.datorama.oss.timbermill.TimberLogger;
import com.datorama.oss.timbermill.pipe.EventOutputPipe;
import com.datorama.oss.timbermill.pipe.TimbermillServerOutputPipeBuilder;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="timbermill")
public class TimbermillBootstraperService {
    private static final Logger LOG = LoggerFactory.getLogger(TimbermillBootstraperService.class);
    @Value(value="${timbermill.log.enabled:false}")
    private boolean timberLogEnabled;
    @Value(value="${env:undefined}")
    private String hostType;
    @Value(value="${timbermill.url:}")
    private String timbermillServer;
    @Value(value="${timbermill.batch.max-size:2097152}")
    private int maxEventsBatchSize;
    @Value(value="${timbermill.buffer.max-size:500000000}")
    private int maxBufferSize;
    @Value(value="${timbermill.batch.max-seconds-interval:3}")
    private int maxSecondsBeforeBatchTimeout;
    @Value(value="${timbermill.env:default}")
    private String timbermillEnv;
    private static final String JVM_UUID = UUID.randomUUID().toString();

    @PostConstruct
    public void init() {
        if (this.timberLogEnabled) {
            if (!StringUtils.isEmpty((CharSequence)this.timbermillServer)) {
                LOG.info(String.format("Bootstrapping TimberLog v2; hostType=%s", this.hostType));
                HashMap<String, String> bootstrapParams = new HashMap<String, String>();
                bootstrapParams.put("host", TimbermillBootstraperService.getHostName());
                bootstrapParams.put("jvm", TimbermillBootstraperService.getJvmUuid());
                bootstrapParams.put("hostType", this.hostType);
                TimbermillServerOutputPipeBuilder builder = new TimbermillServerOutputPipeBuilder().timbermillServerUrl(this.timbermillServer);
                builder.maxEventsBatchSize(this.maxEventsBatchSize);
                builder.maxSecondsBeforeBatchTimeout(this.maxSecondsBeforeBatchTimeout);
                builder.maxBufferSize(this.maxBufferSize);
                TimberLogger.bootstrap((EventOutputPipe)builder.build(), bootstrapParams, (String)this.timbermillEnv);
                TimberLogger.spot((String)"server_startup");
            } else {
                LOG.warn("Timbermill server url is missing, not bootstrapping");
            }
        } else {
            LOG.info("TimberLog DISABLED, not bootstrapping");
        }
    }

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String getJvmUuid() {
        return JVM_UUID;
    }

    @PreDestroy
    public void stop() {
        TimberLogger.exit();
    }
}

