/*
 * Decompiled with CFR 0.152.
 */
package com.datorama.oss.timbermill.pipe;

import com.datorama.oss.timbermill.unit.Event;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

class SizedBoundEventsQueue
extends LinkedBlockingQueue<Event> {
    private AtomicInteger size = new AtomicInteger(0);
    private int maxSize;
    private long maxSecondsBeforeBatchTimeout;

    SizedBoundEventsQueue(int maxSize, long maxSecondsBeforeBatchTimeout) {
        this.maxSize = maxSize;
        this.maxSecondsBeforeBatchTimeout = maxSecondsBeforeBatchTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(Event e) {
        int eventSize = e.estimatedSize();
        SizedBoundEventsQueue sizedBoundEventsQueue = this;
        synchronized (sizedBoundEventsQueue) {
            if (this.size.get() + eventSize <= this.maxSize) {
                this.size.addAndGet(eventSize);
                return super.offer(e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Event poll() {
        SizedBoundEventsQueue sizedBoundEventsQueue = this;
        synchronized (sizedBoundEventsQueue) {
            Event event = (Event)super.poll();
            if (event != null) {
                this.size.addAndGet(-event.estimatedSize());
            }
            return event;
        }
    }

    List<Event> getEventsOfSize(int maxEventsBatchSize) {
        ArrayList<Event> eventsToSend = new ArrayList<Event>();
        try {
            int currentBatchSize = this.addEventFromBufferToList(eventsToSend);
            long startBatchTime = System.currentTimeMillis();
            while (currentBatchSize <= maxEventsBatchSize && !this.isExceededMaxTimeToWait(startBatchTime)) {
                currentBatchSize += this.addEventFromBufferToList(eventsToSend);
            }
        }
        catch (InterruptedException interruptedException) {}
        return eventsToSend;
    }

    private int addEventFromBufferToList(List<Event> eventsToSend) throws InterruptedException {
        Event event = this.poll();
        if (event == null) {
            Thread.sleep(100L);
            return 0;
        }
        event.replaceAllFieldsWithDots();
        event.trimAllStrings();
        eventsToSend.add(event);
        return event.estimatedSize();
    }

    private boolean isExceededMaxTimeToWait(long startBatchTime) {
        return System.currentTimeMillis() - startBatchTime > this.maxSecondsBeforeBatchTimeout * 1000L;
    }

    @Override
    public int size() {
        return this.size.get();
    }
}

