/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common.dataobjects;

import java.util.Locale;

public class TypeInference {
    public static DataType getDataType(Object v) {
        if (DataType.BOOLEAN.isInstance(v)) {
            return DataType.BOOLEAN;
        }
        if (DataType.ORDINAL.isInstance(v)) {
            return DataType.ORDINAL;
        }
        if (DataType.NUMERICAL.isInstance(v)) {
            return DataType.NUMERICAL;
        }
        if (DataType.CATEGORICAL.isInstance(v)) {
            return DataType.CATEGORICAL;
        }
        return null;
    }

    public static Double toDouble(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof Boolean) {
            return (Boolean)v != false ? 1.0 : 0.0;
        }
        return ((Number)v).doubleValue();
    }

    public static Integer toInteger(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof Boolean) {
            return (Boolean)v != false ? 1 : 0;
        }
        return ((Number)v).intValue();
    }

    public static enum DataType {
        BOOLEAN(Boolean.class),
        ORDINAL(Short.class),
        NUMERICAL(Number.class),
        CATEGORICAL(Object.class);

        private final Class klass;

        public static Object parse(String s, DataType dataType) {
            if (s == null || s.isEmpty() || "null".equalsIgnoreCase(s)) {
                return null;
            }
            if (dataType == BOOLEAN) {
                switch (s.toLowerCase(Locale.ENGLISH)) {
                    case "1": 
                    case "true": 
                    case "yes": {
                        return Boolean.TRUE;
                    }
                    case "0": 
                    case "false": 
                    case "no": {
                        return Boolean.FALSE;
                    }
                }
                return null;
            }
            if (dataType == ORDINAL) {
                return Short.valueOf(s);
            }
            if (dataType == NUMERICAL) {
                return Double.valueOf(s);
            }
            if (dataType == CATEGORICAL) {
                return s;
            }
            throw new IllegalArgumentException("Unknown Datatype.");
        }

        private DataType(Class klass) {
            this.klass = klass;
        }

        private boolean isInstance(Object v) {
            return this.klass.isInstance(v);
        }
    }
}

