/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common.storage.abstracts;

import com.datumbox.framework.common.storage.interfaces.BigMap;
import com.datumbox.framework.common.storage.interfaces.StorageConfiguration;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.common.utilities.ReflectionMethods;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStorageEngine<SC extends StorageConfiguration>
implements StorageEngine {
    protected String storageName;
    protected final SC storageConfiguration;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private Thread hook;

    protected AbstractStorageEngine(String storageName, SC storageConfiguration) {
        this.storageName = storageName;
        this.storageConfiguration = storageConfiguration;
        this.hook = new Thread(() -> {
            this.hook = null;
            if (this.isClosed()) {
                return;
            }
            this.close();
        });
        Runtime.getRuntime().addShutdownHook(this.hook);
        this.logger.trace("Opened storage {}", (Object)storageName);
    }

    @Override
    public String getStorageName() {
        return this.storageName;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void close() {
        if (!this.isClosed() && this.hook != null) {
            Runtime.getRuntime().removeShutdownHook(this.hook);
            this.hook = null;
        }
        this.isClosed.set(true);
    }

    protected void assertConnectionOpen() {
        if (this.isClosed()) {
            throw new RuntimeException("The connection is already closed.");
        }
    }

    protected <T extends Serializable> Map<String, Object> preSerializer(T serializableObject) {
        HashMap<String, Object> objReferences = new HashMap<String, Object>();
        for (Field field : ReflectionMethods.getAllFields(new LinkedList<Field>(), serializableObject.getClass())) {
            if (!field.isAnnotationPresent(BigMap.class)) continue;
            field.setAccessible(true);
            try {
                Object value = field.get(serializableObject);
                if (this.isSerializableBigMap(value)) continue;
                objReferences.put(field.getName(), value);
                field.set(serializableObject, null);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
        }
        return objReferences;
    }

    protected abstract Set<Class> nonSerializableBigMaps();

    private boolean isSerializableBigMap(Object value) {
        Class<?> valueClass = value.getClass();
        if (!Serializable.class.isAssignableFrom(valueClass)) {
            return false;
        }
        if (this.nonSerializableBigMaps().contains(valueClass)) {
            return false;
        }
        if (valueClass.getCanonicalName().equals("java.util.Collections.SynchronizedMap")) {
            try {
                Field field = valueClass.getDeclaredField("m");
                field.setAccessible(true);
                if (!Serializable.class.isAssignableFrom(field.get(value).getClass())) {
                    return false;
                }
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                throw new RuntimeException(ex);
            }
        }
        return true;
    }

    protected <T extends Serializable> void postSerializer(T serializableObject, Map<String, Object> objReferences) {
        for (Field field : ReflectionMethods.getAllFields(new LinkedList<Field>(), serializableObject.getClass())) {
            String fieldName = field.getName();
            Object ref = objReferences.remove(fieldName);
            if (ref == null) continue;
            field.setAccessible(true);
            try {
                field.set(serializableObject, ref);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected <T extends Serializable> void postDeserializer(T serializableObject) {
        Method method = null;
        for (Field field : ReflectionMethods.getAllFields(new LinkedList<Field>(), serializableObject.getClass())) {
            if (!field.isAnnotationPresent(BigMap.class)) continue;
            field.setAccessible(true);
            try {
                if (field.get(serializableObject) != null) continue;
                if (method == null) {
                    method = ReflectionMethods.findMethod(serializableObject, "initializeBigMapField", this, field);
                }
                ReflectionMethods.invokeMethod(serializableObject, method, this, field);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

