/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.storage.mapdb;

import com.datumbox.framework.common.storage.abstracts.AbstractFileStorageConfiguration;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.storage.mapdb.MapDBEngine;
import java.util.Properties;

public class MapDBConfiguration
extends AbstractFileStorageConfiguration {
    private int cacheSize = 10000;
    private boolean compressed = true;
    private boolean hybridized = true;
    private boolean asynchronous = true;

    public StorageEngine createStorageEngine(String storageName) {
        return new MapDBEngine(storageName, this);
    }

    public void load(Properties properties) {
        this.directory = properties.getProperty("mapDBConfiguration.directory");
        this.cacheSize = Integer.parseInt(properties.getProperty("mapDBConfiguration.cacheSize"));
        this.compressed = "true".equalsIgnoreCase(properties.getProperty("mapDBConfiguration.compressed"));
        this.hybridized = "true".equalsIgnoreCase(properties.getProperty("mapDBConfiguration.hybridized"));
        this.asynchronous = "true".equalsIgnoreCase(properties.getProperty("mapDBConfiguration.asynchronous"));
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public boolean isHybridized() {
        return this.hybridized;
    }

    public void setHybridized(boolean hybridized) {
        this.hybridized = hybridized;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }
}

