/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.storage.mapdb;

import com.datumbox.framework.common.storage.abstracts.AbstractFileStorageConfiguration;
import com.datumbox.framework.common.storage.abstracts.AbstractFileStorageEngine;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.storage.mapdb.MapDBConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import org.mapdb.Atomic;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;

public class MapDBEngine
extends AbstractFileStorageEngine<MapDBConfiguration> {
    private final Map<StorageType, DB> storageRegistry = new HashMap<StorageType, DB>();

    protected MapDBEngine(String storageName, MapDBConfiguration storageConfiguration) {
        super(storageName, (AbstractFileStorageConfiguration)storageConfiguration);
    }

    public boolean rename(String newStorageName) {
        this.assertConnectionOpen();
        if (this.storageName.equals(newStorageName)) {
            return false;
        }
        this.blockedStorageClose(StorageType.PRIMARY_STORAGE);
        this.blockedStorageClose(StorageType.SECONDARY_STORAGE);
        try {
            this.moveDirectory(this.getRootPath(this.storageName), this.getRootPath(newStorageName));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        this.logger.trace("Renamed storage {} to {}", (Object)this.storageName, (Object)newStorageName);
        this.storageName = newStorageName;
        return true;
    }

    public boolean existsObject(String name) {
        this.assertConnectionOpen();
        DB storage = this.openStorage(StorageType.PRIMARY_STORAGE);
        return storage.exists(name);
    }

    public <T extends Serializable> void saveObject(String name, T serializableObject) {
        this.assertConnectionOpen();
        DB storage = this.openStorage(StorageType.PRIMARY_STORAGE);
        Atomic.Var atomicVar = storage.getAtomicVar(name);
        Map objRefs = this.preSerializer(serializableObject);
        atomicVar.set(serializableObject);
        storage.commit();
        this.postSerializer(serializableObject, objRefs);
    }

    public <T extends Serializable> T loadObject(String name, Class<T> klass) throws NoSuchElementException {
        this.assertConnectionOpen();
        if (!this.existsObject(name)) {
            throw new NoSuchElementException("Can't find any object with name '" + name + "'");
        }
        DB storage = this.openStorage(StorageType.PRIMARY_STORAGE);
        Atomic.Var atomicVar = storage.getAtomicVar(name);
        Serializable serializableObject = (Serializable)klass.cast(atomicVar.get());
        this.postDeserializer(serializableObject);
        return (T)serializableObject;
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        super.close();
        this.closeStorageRegistry();
        this.logger.trace("Closed storage {}", (Object)this.storageName);
    }

    public void clear() {
        this.assertConnectionOpen();
        this.closeStorageRegistry();
        try {
            this.deleteDirectory(this.getRootPath(this.storageName), true);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <K, V> Map<K, V> getBigMap(String name, Class<K> keyClass, Class<V> valueClass, StorageEngine.MapType type, StorageEngine.StorageHint storageHint, boolean isConcurrent, boolean isTemporary) {
        void var10_13;
        this.assertConnectionOpen();
        if (storageHint == StorageEngine.StorageHint.IN_MEMORY && ((MapDBConfiguration)this.storageConfiguration).isHybridized()) {
            if (StorageEngine.MapType.HASHMAP.equals((Object)type)) {
                return isConcurrent ? new ConcurrentHashMap() : new HashMap();
            }
            if (!StorageEngine.MapType.TREEMAP.equals((Object)type)) throw new IllegalArgumentException("Unsupported MapType.");
            return isConcurrent ? new ConcurrentSkipListMap() : new TreeMap();
        }
        StorageType storageType = this.getStorageTypeFromName(name);
        if (storageType == null) {
            if (!isTemporary) {
                if (storageHint == StorageEngine.StorageHint.IN_MEMORY || storageHint == StorageEngine.StorageHint.IN_CACHE) {
                    storageType = StorageType.PRIMARY_STORAGE;
                } else {
                    if (storageHint != StorageEngine.StorageHint.IN_DISK) throw new IllegalArgumentException("Unsupported StorageHint.");
                    storageType = StorageType.SECONDARY_STORAGE;
                }
            } else if (storageHint == StorageEngine.StorageHint.IN_MEMORY || storageHint == StorageEngine.StorageHint.IN_CACHE) {
                storageType = StorageType.TEMP_PRIMARY_STORAGE;
            } else {
                if (storageHint != StorageEngine.StorageHint.IN_DISK) throw new IllegalArgumentException("Unsupported StorageHint.");
                storageType = StorageType.TEMP_SECONDARY_STORAGE;
            }
        }
        DB storage = this.openStorage(storageType);
        if (StorageEngine.MapType.HASHMAP.equals((Object)type)) {
            HTreeMap hTreeMap = storage.createHashMap(name).counterEnable().keySerializer(this.getSerializerFromClass(keyClass)).valueSerializer(this.getSerializerFromClass(valueClass)).makeOrGet();
            return var10_13;
        } else {
            if (!StorageEngine.MapType.TREEMAP.equals((Object)type)) throw new IllegalArgumentException("Unsupported MapType.");
            BTreeMap bTreeMap = storage.createTreeMap(name).valuesOutsideNodesEnable().counterEnable().keySerializer(this.getBTreeKeySerializerFromClass(keyClass)).valueSerializer(this.getSerializerFromClass(valueClass)).makeOrGet();
            if (!isConcurrent) return var10_13;
            Map map = Collections.synchronizedMap(bTreeMap);
        }
        return var10_13;
    }

    public <T extends Map> void dropBigMap(String name, T map) {
        this.assertConnectionOpen();
        StorageType storageType = this.getStorageTypeFromName(name);
        if (storageType != null) {
            DB storage = this.storageRegistry.get((Object)storageType);
            if (this.isOpenStorage(storage)) {
                storage.delete(name);
            }
        } else {
            map.clear();
        }
    }

    protected Set<Class> nonSerializableBigMaps() {
        return new HashSet<Class>(Arrays.asList(HTreeMap.class, BTreeMap.class));
    }

    private Serializer<?> getSerializerFromClass(Class<?> klass) {
        if (klass == Integer.class) {
            return Serializer.INTEGER;
        }
        if (klass == Long.class) {
            return Serializer.LONG;
        }
        if (klass == Boolean.class) {
            return Serializer.BOOLEAN;
        }
        if (klass == String.class) {
            return Serializer.STRING;
        }
        return null;
    }

    private BTreeKeySerializer<?> getBTreeKeySerializerFromClass(Class<?> klass) {
        if (klass == Integer.class) {
            return BTreeKeySerializer.ZERO_OR_POSITIVE_INT;
        }
        if (klass == Long.class) {
            return BTreeKeySerializer.ZERO_OR_POSITIVE_LONG;
        }
        if (klass == String.class) {
            return BTreeKeySerializer.STRING;
        }
        return null;
    }

    private boolean isOpenStorage(DB storage) {
        return storage != null && !storage.isClosed();
    }

    private DB openStorage(StorageType storageType) {
        DB storage = this.storageRegistry.get((Object)storageType);
        if (!this.isOpenStorage(storage)) {
            DBMaker m;
            if (storageType == StorageType.PRIMARY_STORAGE || storageType == StorageType.SECONDARY_STORAGE) {
                Path rootPath = this.getRootPath(this.storageName);
                try {
                    this.createDirectoryIfNotExists(rootPath);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
                m = DBMaker.newFileDB((File)new File(rootPath.toFile(), storageType.toString()));
            } else if (storageType == StorageType.TEMP_PRIMARY_STORAGE || storageType == StorageType.TEMP_SECONDARY_STORAGE) {
                m = DBMaker.newTempFileDB().deleteFilesAfterClose();
            } else {
                throw new IllegalArgumentException("Unsupported StorageType.");
            }
            if (((MapDBConfiguration)this.storageConfiguration).isCompressed()) {
                m = m.compressionEnable();
            }
            boolean permitCaching = storageType == StorageType.PRIMARY_STORAGE || storageType == StorageType.TEMP_PRIMARY_STORAGE;
            m = permitCaching && ((MapDBConfiguration)this.storageConfiguration).getCacheSize() > 0 ? m.cacheLRUEnable().cacheSize(((MapDBConfiguration)this.storageConfiguration).getCacheSize()) : m.cacheDisable();
            if (((MapDBConfiguration)this.storageConfiguration).isAsynchronous()) {
                m = m.asyncWriteEnable();
            }
            m = m.transactionDisable();
            m = m.closeOnJvmShutdown();
            storage = m.make();
            this.storageRegistry.put(storageType, storage);
        }
        return storage;
    }

    private StorageType getStorageTypeFromName(String name) {
        for (Map.Entry<StorageType, DB> entry : this.storageRegistry.entrySet()) {
            DB storage = entry.getValue();
            if (!this.isOpenStorage(storage) || !storage.exists(name)) continue;
            return entry.getKey();
        }
        return null;
    }

    private void closeStorageRegistry() {
        for (DB storage : this.storageRegistry.values()) {
            if (!this.isOpenStorage(storage)) continue;
            storage.close();
        }
        this.storageRegistry.clear();
    }

    private boolean blockedStorageClose(StorageType storageType) {
        DB storage = this.storageRegistry.get((Object)storageType);
        if (this.isOpenStorage(storage)) {
            storage.commit();
            Engine e = storage.getEngine();
            while (EngineWrapper.class.isAssignableFrom(e.getClass())) {
                e = ((EngineWrapper)e).getWrappedEngine();
            }
            storage.close();
            while (!e.isClosed()) {
                this.logger.trace("Waiting for the engine to close");
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return true;
        }
        return false;
    }

    private static enum StorageType {
        PRIMARY_STORAGE,
        SECONDARY_STORAGE,
        TEMP_PRIMARY_STORAGE,
        TEMP_SECONDARY_STORAGE;

    }
}

