/*
 * Decompiled with CFR 0.152.
 */
package com.daveayan.fuzzyavenger.providers.akka;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.daveayan.fuzzyavenger.ExecutionProvider;
import com.daveayan.fuzzyavenger.Function;
import com.daveayan.fuzzyavenger.providers.akka.ActorLevel0_SystemShutdowner;
import com.daveayan.fuzzyavenger.providers.akka.ActorLevel1;
import com.daveayan.fuzzyavenger.providers.akka.Message_AL1_to_AL0;
import com.daveayan.fuzzyavenger.providers.akka.Message_Runner_to_AL1;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public class AkkaExecutionProvider
implements ExecutionProvider {
    public ActorRef shutdownCommandListener;
    public ActorSystem system;

    public static ExecutionProvider newInstance() {
        AkkaExecutionProvider ep = new AkkaExecutionProvider();
        ep.initialize();
        return ep;
    }

    @Override
    public void initialize() {
        this.system = ActorSystem.create((String)("fuzzy-avenger-" + System.currentTimeMillis()));
        this.shutdownCommandListener = this.system.actorOf(new Props(ActorLevel0_SystemShutdowner.class), "shutdownCommandListener");
    }

    @Override
    public List<Object> run(List<Object> data, List<Object> parameters, Function<?, ?> functionToApply, final int numberOfWorkers, int numberOfSecondsTimeout) {
        final ImmutableList iData = ImmutableList.builder().addAll(data).build();
        ActorRef actorLevel1 = this.system.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() {
                return new ActorLevel1((List<Object>)iData, numberOfWorkers);
            }
        }), "ActorLevel1-" + System.currentTimeMillis());
        Timeout timeout = new Timeout(Duration.create((long)numberOfSecondsTimeout, (String)"seconds"));
        Future future = Patterns.ask((ActorRef)actorLevel1, (Object)new Message_Runner_to_AL1(parameters, functionToApply), (Timeout)timeout);
        List<Object> results = new ArrayList<Object>();
        try {
            results = (List)Await.result((Awaitable)future, (Duration)timeout.duration());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    @Override
    public void shutdown() {
        this.shutdownCommandListener.tell((Object)new Message_AL1_to_AL0(), ActorRef.noSender());
    }
}

