/*
 * Decompiled with CFR 0.152.
 */
package cucumber.junit;

import cucumber.junit.ExecutionUnitRunner;
import cucumber.runtime.PendingException;
import daveayan.gherkinsalad.ReportFeatureScenarioStep;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;

class JUnitReporter
implements Reporter,
Formatter {
    private final List<Step> steps = new ArrayList<Step>();
    private final Reporter reporter;
    private final Formatter formatter;
    private final boolean strict;
    EachTestNotifier stepNotifier;
    private ExecutionUnitRunner executionUnitRunner;
    private RunNotifier runNotifier;
    EachTestNotifier executionUnitNotifier;
    private boolean ignoredStep;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public JUnitReporter(Reporter reporter, Formatter formatter, boolean strict) {
        this.reporter = reporter;
        this.formatter = formatter;
        this.strict = strict;
    }

    public void startExecutionUnit(ExecutionUnitRunner executionUnitRunner, RunNotifier runNotifier) {
        this.executionUnitRunner = executionUnitRunner;
        this.runNotifier = runNotifier;
        this.stepNotifier = null;
        this.ignoredStep = false;
        this.executionUnitNotifier = new EachTestNotifier(runNotifier, executionUnitRunner.getDescription());
        this.executionUnitNotifier.fireTestStarted();
    }

    public void finishExecutionUnit() {
        if (this.ignoredStep) {
            this.executionUnitNotifier.fireTestIgnored();
        } else {
            this.executionUnitNotifier.fireTestFinished();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void match(Match match) {
        void match2;
        Match match3 = match;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)match3);
        ReportFeatureScenarioStep.aspectOf().ajc$before$daveayan_gherkinsalad_ReportFeatureScenarioStep$3$fe9f4b4d(joinPoint);
        Description description = this.executionUnitRunner.describeChild(this.steps.remove(0));
        this.stepNotifier = new EachTestNotifier(this.runNotifier, description);
        this.reporter.match((Match)match2);
    }

    public void embedding(String mimeType, InputStream data) {
        this.reporter.embedding(mimeType, data);
    }

    public void write(String text) {
        this.reporter.write(text);
    }

    public void result(Result result) {
        Throwable error = result.getError();
        if (Result.SKIPPED == result) {
            this.stepNotifier.fireTestIgnored();
        } else if (this.isPendingOrUndefined(result)) {
            this.addFailureOrIgnoreStep(result);
        } else {
            if (this.stepNotifier != null) {
                this.stepNotifier.fireTestStarted();
                if (error != null) {
                    this.stepNotifier.addFailure(error);
                }
                this.stepNotifier.fireTestFinished();
            }
            if (error != null) {
                this.executionUnitNotifier.addFailure(error);
            }
        }
        if (this.steps.isEmpty()) {
            this.stepNotifier = null;
        }
        this.reporter.result(result);
    }

    private boolean isPendingOrUndefined(Result result) {
        Throwable error = result.getError();
        return Result.UNDEFINED == result || error instanceof PendingException;
    }

    private void addFailureOrIgnoreStep(Result result) {
        if (this.strict) {
            this.addFailure(result);
        } else {
            this.ignoredStep = true;
            this.stepNotifier.fireTestIgnored();
        }
    }

    private void addFailure(Result result) {
        Throwable error = result.getError();
        if (error == null) {
            error = new PendingException();
        }
        this.stepNotifier.addFailure(error);
        this.executionUnitNotifier.addFailure(error);
    }

    public void uri(String uri) {
        this.formatter.uri(uri);
    }

    public void feature(Feature feature) {
        this.formatter.feature(feature);
    }

    public void background(Background background) {
        this.formatter.background(background);
    }

    public void scenario(Scenario scenario) {
        this.formatter.scenario(scenario);
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.formatter.scenarioOutline(scenarioOutline);
    }

    public void examples(Examples examples) {
        this.formatter.examples(examples);
    }

    public void step(Step step) {
        this.steps.add(step);
        this.formatter.step(step);
    }

    public void eof() {
        this.formatter.eof();
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, int line) {
        this.formatter.syntaxError(state, event, legalEvents, uri, line);
    }

    public void done() {
        this.formatter.done();
    }

    public void close() {
        this.formatter.close();
    }

    static {
        JUnitReporter.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JUnitReporter.java", JUnitReporter.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "match", "cucumber.junit.JUnitReporter", "gherkin.formatter.model.Match", "match", "", "void"), 59);
    }
}

