/*
 * Decompiled with CFR 0.152.
 */
package daveayan.gherkinsalad.components.jqueryui.datepicker;

import daveayan.gherkinsalad.components.core.Component;
import daveayan.gherkinsalad.components.core.Element;
import daveayan.gherkinsalad.components.html.Clickable;
import daveayan.gherkinsalad.components.html.impl.Link;
import daveayan.gherkinsalad.components.jqueryui.datepicker.DatePicker;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;

public class DefaultDatePicker
extends Component
implements DatePicker {
    private static Log log = LogFactory.getLog(DefaultDatePicker.class);
    public Clickable next_month = Link.find((By)By.className((String)"ui-datepicker-next")).name("Date Picker - Next Month");
    public Clickable prev_month = Link.find((By)By.className((String)"ui-datepicker-prev")).name("Date Picker - Previous Month");

    public void select_date_except_weekends(Date date_to_select, Date current_date) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date_to_select);
        cal2.setTime(current_date);
        this.select_date_except_weekends(cal1, cal2);
    }

    public void select_date(Date date_to_select, Date current_date) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date_to_select);
        cal2.setTime(current_date);
        this.select_date(cal1, cal2);
    }

    private void select_date_except_weekends(Calendar date_to_select, Calendar current_date) {
        if (date_to_select.get(7) == 7) {
            date_to_select.add(5, -1);
        }
        if (date_to_select.get(7) == 1) {
            date_to_select.add(5, -2);
        }
        this.select_date(date_to_select, current_date);
    }

    private void select_date(Calendar date_to_select, Calendar current_date) {
        this.takeScreenshot();
        int day = date_to_select.get(5);
        int year = date_to_select.get(1);
        String month_name = date_to_select.getDisplayName(2, 2, Locale.US);
        log.info((Object)("date_to_select = " + date_to_select.getTime() + ", current_date = " + current_date.getTime()));
        while (true) {
            String cal_month_text = this.get_month_in_picker();
            String cal_year_text = this.get_year_in_picker();
            log.info((Object)("To Select: '" + month_name + "/" + year + "', In Calendar '" + cal_month_text + "/" + cal_year_text + "', "));
            if (StringUtils.equalsIgnoreCase((String)month_name, (String)cal_month_text) && StringUtils.equalsIgnoreCase((String)(year + ""), (String)cal_year_text)) break;
            if (date_to_select.after(current_date)) {
                this.next_month.click_if_enabled();
                continue;
            }
            if (!date_to_select.before(current_date)) continue;
            this.prev_month.click_if_enabled();
        }
        log.info((Object)"Found month and year, finding day");
        Link.find((By)By.linkText((String)(day + ""))).name("Date Picker - Day " + day).click_if_enabled();
        this.takeScreenshot();
    }

    private String get_month_in_picker() {
        Element cal_month;
        String cal_month_text;
        while (!StringUtils.isNotEmpty((String)(cal_month_text = (cal_month = this.root_element().findElement(By.className((String)"ui-datepicker-month")).name("Date Picker - Month")).getText()))) {
        }
        return cal_month_text;
    }

    private String get_year_in_picker() {
        Element cal_year;
        String cal_year_text;
        while (!StringUtils.isNotEmpty((String)(cal_year_text = (cal_year = this.root_element().findElement(By.className((String)"ui-datepicker-year")).name("Date Picker - Year")).getText()))) {
        }
        return cal_year_text;
    }

    public DefaultDatePicker() {
        this.found(By.id((String)"ui-datepicker-div"));
        this.next_month.found(By.className((String)"ui-datepicker-next"));
        this.prev_month.found(By.className((String)"ui-datepicker-prev"));
    }
}

