/*
 * Decompiled with CFR 0.152.
 */
package daveayan.gherkinsalad.components.jqueryui.selectmenu;

import com.google.common.base.Predicate;
import daveayan.gherkinsalad.Strings;
import daveayan.gherkinsalad.components.core.Element;
import daveayan.gherkinsalad.components.core.Elements;
import daveayan.gherkinsalad.components.html.SingleOptionSelectable;
import daveayan.gherkinsalad.components.html.impl.SingleOptionSelectableDropDown;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.By;

public class DefaultSelectMenu
extends SingleOptionSelectableDropDown
implements SingleOptionSelectable {
    public static DefaultSelectMenu find(By locator) {
        DefaultSelectMenu m = new DefaultSelectMenu();
        m.found(locator);
        return m;
    }

    public Strings get_all_options() {
        List options = ListUtils.EMPTY_LIST;
        if (this.isEnabled()) {
            this.click_if_enabled();
            Element ul = this.find_ul_element();
            Elements li_a_s = ul.findElements(By.tagName((String)"a"));
            options = li_a_s.asString();
            this.click_if_enabled();
        }
        return Strings.instance_from((List)options);
    }

    public String get_selected_option_text() {
        String option = "";
        if (this.isEnabled()) {
            this.click_if_enabled();
            Element ul = this.find_ul_element();
            Elements li_s = ul.findElements(By.tagName((String)"a"));
            Element selected_element = li_s.findFirstElementThatMatches((Predicate)new Predicate<Element>(){

                public boolean apply(Element li_a) {
                    String value = li_a.getAttribute("aria-selected");
                    if (StringUtils.isBlank((String)value)) {
                        return false;
                    }
                    return Boolean.parseBoolean(value);
                }
            });
            if (selected_element.is_not_null()) {
                this.info("Selected element is " + selected_element);
                option = selected_element.getText();
            }
            this.click_if_enabled();
        }
        return option;
    }

    public void select_code_if_enabled(String arg0) {
    }

    public void select_option_if_enabled(String option) {
        if (this.isEnabled()) {
            this.click_if_enabled();
            Element ul = this.find_ul_element();
            Element element_to_select = ul.findElement(By.partialLinkText((String)option));
            element_to_select.click();
        }
    }

    public boolean isEnabled() {
        if (this.isDisplayed()) {
            Element a_link = this.root_element();
            return !StringUtils.equalsIgnoreCase((String)a_link.getAttribute("aria-disabled"), (String)"true");
        }
        return false;
    }

    private Element find_ul_element() {
        Element a_link = this.root_element();
        String a_link_id = a_link.getAttribute("id");
        String ul_id = a_link_id.split("-button")[0] + "-menu";
        Element ul = this.findElement(By.id((String)ul_id));
        return ul;
    }

    private void click_if_enabled() {
        if (this.isEnabled()) {
            this.root_element().click();
            this.wait_for_seconds(1);
        }
    }
}

