/*
 * Decompiled with CFR 0.152.
 */
package daveayan.gherkinsalad.components.jqueryui.tabs;

import com.google.common.base.Predicate;
import daveayan.gherkinsalad.components.core.BaseBrowserElement;
import daveayan.gherkinsalad.components.core.Element;
import daveayan.gherkinsalad.components.core.Elements;
import daveayan.gherkinsalad.components.jqueryui.tabs.Tabs;
import org.openqa.selenium.By;

public class DefaultTabSelector
extends BaseBrowserElement
implements Tabs {
    private DefaultTabSelector() {
    }

    public static Tabs find(By root) {
        DefaultTabSelector t = new DefaultTabSelector();
        t.found(root);
        return t;
    }

    public void select_tab(String tab_name) {
        Element tab = this.find_tab_li(tab_name);
        if (this.tab_is_selected(tab)) {
            this.info("Tab '" + tab_name + "' is already selected.");
        } else {
            this.action("Selecting tab '" + tab_name + "', element '" + tab + "'");
            tab.findElement(By.tagName((String)"a")).click();
        }
        this.takeScreenshot();
    }

    public void selected_tab_should_be(String expected_selected_tab) {
        Element tab = this.find_tab_li(expected_selected_tab);
        if (this.tab_is_selected(tab)) {
            this.action("Verified that tab '" + expected_selected_tab + "' is selected");
        } else {
            this.error("Expected tab '" + expected_selected_tab + "' to be selected, it is not");
        }
        this.takeScreenshot();
    }

    public void selected_tab_should_not_be(String expected_selected_tab) {
        Element tab = this.find_tab_li(expected_selected_tab);
        if (!this.tab_is_selected(tab)) {
            this.action("Verified that tab '" + expected_selected_tab + "' is not selected");
        } else {
            this.error("Expected tab '" + expected_selected_tab + "' to be not selected, it is");
        }
        this.takeScreenshot();
    }

    public void remove_tab(String tab_to_remove) {
        Element tab = this.find_tab_li(tab_to_remove);
        Element tab_close_icon = tab.findElement(By.className((String)"ui-icon-close"));
        if (tab_close_icon.is_null()) {
            this.error("Tab '" + tab_to_remove + "' does not have the icon to close it. Cannot remove");
        } else {
            tab_close_icon.click();
            this.action("Tab '" + tab_to_remove + "' removed.");
        }
        this.takeScreenshot();
    }

    private boolean tab_is_selected(Element tab) {
        return tab.getAttribute("aria-selected").contains("true");
    }

    private Element find_tab_li(final String tab_name) {
        Elements tabs = this.root_element().findElements(By.tagName((String)"li"));
        Element tab = tabs.findFirstElementThatMatches((Predicate)new Predicate<Element>(){

            public boolean apply(Element arg0) {
                return arg0.is(tab_name);
            }
        });
        return tab;
    }
}

