/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.script;

import com.davfx.script.AsyncScriptFunction;
import com.davfx.script.ScriptRunner;
import com.davfx.script.ScriptUtils;
import com.davfx.script.SyncScriptFunction;
import com.davfx.util.ClassThreadFactory;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorScriptRunner
implements ScriptRunner,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorScriptRunner.class);
    private static final Config CONFIG = ConfigFactory.load((ClassLoader)ExecutorScriptRunner.class.getClassLoader());
    private static final boolean USE_TO_STRING;
    private static final String ENGINE_NAME;
    public static final String CALL_FUNCTION_NAME;
    public static final String UNICITY_PREFIX;
    private final ScriptEngine scriptEngine;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)new ClassThreadFactory(ExecutorScriptRunner.class));
    private int nextUnicityId = 0;
    private final Map<String, EndManager> endManagers = new HashMap<String, EndManager>();
    private final List<String> registeredFunctions = new LinkedList<String>();

    public ExecutorScriptRunner() {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        this.scriptEngine = scriptEngineManager.getEngineByName(ENGINE_NAME);
        if (this.scriptEngine == null) {
            throw new IllegalArgumentException("Bad engine: " + ENGINE_NAME);
        }
        LOGGER.debug("Script engine {}/{}", (Object)this.scriptEngine.getFactory().getEngineName(), (Object)this.scriptEngine.getFactory().getEngineVersion());
        try {
            this.scriptEngine.eval(ScriptUtils.functions());
            this.scriptEngine.eval("var " + UNICITY_PREFIX + "nextUnicityId = 0;" + "var " + UNICITY_PREFIX + "callbacks = {};");
            if (USE_TO_STRING) {
                this.scriptEngine.eval("var " + UNICITY_PREFIX + "convertFrom = JSON.stringify;" + "var " + UNICITY_PREFIX + "convertTo = JSON.parse;");
            } else {
                this.scriptEngine.eval("var " + UNICITY_PREFIX + "convertFrom = function(o) {" + "if (o == null) {" + "return null;" + "}" + "if (o instanceof Array) {" + "var p = new com.google.gson.JsonArray();" + "for (k in o) {" + "p.add(" + UNICITY_PREFIX + "convertFrom(o[k]));" + "}" + "return p;" + "}" + "if (o instanceof Object) {" + "var p = new com.google.gson.JsonObject();" + "for (k in o) {" + "p.add(k, " + UNICITY_PREFIX + "convertFrom(o[k]));" + "}" + "return p;" + "}" + "if (typeof o == \"string\") {" + "return " + ExecutorScriptRunner.class.getName() + ".jsonString(o);" + "}" + "if (typeof o == \"number\") {" + "return " + ExecutorScriptRunner.class.getName() + ".jsonNumber(o);" + "}" + "if (typeof o == \"boolean\") {" + "return " + ExecutorScriptRunner.class.getName() + ".jsonBoolean(o);" + "}" + "};" + "var " + UNICITY_PREFIX + "convertTo = function(o) {" + "if (o == null) {" + "return null;" + "}" + "if (o.isJsonObject()) {" + "var i = o.entrySet().iterator();" + "var p = {};" + "while (i.hasNext()) {" + "var e = i.next();" + "p[e.getKey()] = " + UNICITY_PREFIX + "convertTo(e.getValue());" + "}" + "return p;" + "}" + "if (o.isJsonPrimitive()) {" + "var oo = o.getAsJsonPrimitive();" + "if (oo.isString()) {" + "return '' + oo.getAsString();" + "}" + "if (oo.isNumber()) {" + "return oo.getAsDouble();" + "}" + "if (oo.isBoolean()) {" + "return oo.getAsBoolean();" + "}" + "return null;" + "}" + "return null;" + "};");
            }
        }
        catch (Exception se) {
            LOGGER.error("Could not initialize script engine", (Throwable)se);
        }
    }

    @Override
    public void close() {
        LOGGER.debug("Script engine closed");
        this.executorService.shutdown();
    }

    @Override
    public void register(final String function, final SyncScriptFunction syncFunction) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                String id = String.valueOf(ExecutorScriptRunner.this.nextUnicityId);
                ExecutorScriptRunner.this.nextUnicityId++;
                String functionObjectVar = UNICITY_PREFIX + "function_" + function + id;
                ExecutorScriptRunner.this.scriptEngine.getBindings(100).put(functionObjectVar, (Object)new SyncInternal(syncFunction));
                try {
                    ExecutorScriptRunner.this.scriptEngine.eval("var " + function + " = function(p) {" + "var q = null;" + "if (p) {" + "q = " + UNICITY_PREFIX + "convertFrom(p);" + "}" + "var r = " + functionObjectVar + ".call(q);" + "if (r == null) {" + "return null;" + "}" + "return " + UNICITY_PREFIX + "convertTo(r);" + "};");
                }
                catch (Exception se) {
                    LOGGER.error("Could not register {}", (Object)function, (Object)se);
                }
            }
        });
    }

    @Override
    public void register(final String function, final AsyncScriptFunction asyncFunction) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                String id = String.valueOf(ExecutorScriptRunner.this.nextUnicityId);
                ExecutorScriptRunner.this.nextUnicityId++;
                String functionObjectVar = UNICITY_PREFIX + "function_" + function + id;
                ExecutorScriptRunner.this.scriptEngine.getBindings(100).put(functionObjectVar, (Object)new AsyncInternal(function, asyncFunction));
                try {
                    ExecutorScriptRunner.this.scriptEngine.eval("var " + UNICITY_PREFIX + function + " = function(instanceId) {" + "return function(p, callback) {" + "var q = null;" + "if (p) {" + "q = " + UNICITY_PREFIX + "convertFrom(p);" + "}" + "var callbackId = '" + function + id + "_' + " + UNICITY_PREFIX + "nextUnicityId;" + UNICITY_PREFIX + "nextUnicityId++;" + UNICITY_PREFIX + "callbacks[callbackId] = callback;" + functionObjectVar + ".call(instanceId, q, callbackId);" + "};" + "};");
                    ExecutorScriptRunner.this.registeredFunctions.add(function);
                }
                catch (Exception se) {
                    LOGGER.error("Could not register {}", (Object)function, (Object)se);
                }
            }
        });
    }

    private EndManager endManager(final List<String> bindingsToRemove, final ScriptRunner.End end) {
        final String instanceId = String.valueOf(this.nextUnicityId);
        ++this.nextUnicityId;
        final Runnable clean = new Runnable(){

            @Override
            public void run() {
                ExecutorScriptRunner.this.endManagers.remove(instanceId);
                if (bindingsToRemove != null) {
                    for (String functionObjectVar : bindingsToRemove) {
                        ExecutorScriptRunner.this.scriptEngine.getBindings(100).put(functionObjectVar, (Object)null);
                        ExecutorScriptRunner.this.scriptEngine.getBindings(100).remove(functionObjectVar);
                    }
                }
            }
        };
        EndManager endManager = new EndManager(instanceId, new ScriptRunner.End(){

            @Override
            public void failed(Exception e) {
                clean.run();
                if (end != null) {
                    end.failed(e);
                }
            }

            @Override
            public void ended() {
                clean.run();
                if (end != null) {
                    end.ended();
                }
            }
        });
        this.endManagers.put(instanceId, endManager);
        return endManager;
    }

    private void addRegisteredFunctions(StringBuilder scriptBuilder, String instanceId) {
        for (String function : this.registeredFunctions) {
            scriptBuilder.append("var " + function + " = " + UNICITY_PREFIX + function + "('" + instanceId + "');");
        }
    }

    @Override
    public void prepare(final String script, final ScriptRunner.End end) {
        if (this.executorService.isShutdown()) {
            return;
        }
        this.executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EndManager endManager = ExecutorScriptRunner.this.endManager(null, end);
                endManager.inc();
                try {
                    StringBuilder scriptBuilder = new StringBuilder();
                    ExecutorScriptRunner.this.addRegisteredFunctions(scriptBuilder, endManager.instanceId);
                    scriptBuilder.append(script);
                    String s = scriptBuilder.toString();
                    try {
                        ExecutorScriptRunner.this.scriptEngine.eval(s);
                    }
                    catch (Exception se) {
                        LOGGER.error("Script error: {}", (Object)s, (Object)se);
                        endManager.fail(new IOException(se));
                    }
                }
                finally {
                    endManager.dec();
                }
            }
        });
    }

    @Override
    public ScriptRunner.Engine engine() {
        return new ScriptRunner.Engine(){
            private final Map<String, SyncScriptFunction> syncFunctions = new LinkedHashMap<String, SyncScriptFunction>();
            private final Map<String, AsyncScriptFunction> asyncFunctions = new LinkedHashMap<String, AsyncScriptFunction>();

            @Override
            public void register(String function, SyncScriptFunction syncFunction) {
                this.syncFunctions.put(function, syncFunction);
            }

            @Override
            public void register(String function, AsyncScriptFunction asyncFunction) {
                this.asyncFunctions.put(function, asyncFunction);
            }

            @Override
            public void eval(final String script, final ScriptRunner.End end) {
                if (ExecutorScriptRunner.this.executorService.isShutdown()) {
                    return;
                }
                ExecutorScriptRunner.this.executorService.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        LinkedList<String> bindingsToRemove = new LinkedList<String>();
                        EndManager endManager = ExecutorScriptRunner.this.endManager(bindingsToRemove, end);
                        endManager.inc();
                        try {
                            String functionObjectVar;
                            String id;
                            String function;
                            String closureId = String.valueOf(ExecutorScriptRunner.this.nextUnicityId);
                            ExecutorScriptRunner.this.nextUnicityId++;
                            StringBuilder scriptBuilder = new StringBuilder();
                            scriptBuilder.append("var " + UNICITY_PREFIX + "closure" + closureId + " = function() {");
                            ExecutorScriptRunner.this.addRegisteredFunctions(scriptBuilder, endManager.instanceId);
                            for (Map.Entry e : syncFunctions.entrySet()) {
                                function = (String)e.getKey();
                                SyncScriptFunction syncFunction = (SyncScriptFunction)e.getValue();
                                id = String.valueOf(ExecutorScriptRunner.this.nextUnicityId);
                                ExecutorScriptRunner.this.nextUnicityId++;
                                functionObjectVar = UNICITY_PREFIX + "function_" + function + id;
                                ExecutorScriptRunner.this.scriptEngine.getBindings(100).put(functionObjectVar, (Object)new SyncInternal(syncFunction));
                                bindingsToRemove.add(functionObjectVar);
                                scriptBuilder.append("var " + function + " = function(p) {" + "var q = null;" + "if (p) {" + "q = " + UNICITY_PREFIX + "convertFrom(p);" + "}" + "var r = " + functionObjectVar + ".call(q);" + "if (r == null) {" + "return null;" + "}" + "return " + UNICITY_PREFIX + "convertTo(r);" + "};");
                            }
                            for (Map.Entry e : asyncFunctions.entrySet()) {
                                function = (String)e.getKey();
                                AsyncScriptFunction asyncFunction = (AsyncScriptFunction)e.getValue();
                                id = String.valueOf(ExecutorScriptRunner.this.nextUnicityId);
                                ExecutorScriptRunner.this.nextUnicityId++;
                                functionObjectVar = UNICITY_PREFIX + "function_" + function + id;
                                ExecutorScriptRunner.this.scriptEngine.getBindings(100).put(functionObjectVar, (Object)new AsyncInternal(function, asyncFunction));
                                bindingsToRemove.add(functionObjectVar);
                                scriptBuilder.append("var " + function + " = function(p, callback) {" + "var q = null;" + "if (p) {" + "q = " + UNICITY_PREFIX + "convertFrom(p);" + "}" + "var callbackId = '" + function + id + "_' + " + UNICITY_PREFIX + "nextUnicityId;" + UNICITY_PREFIX + "nextUnicityId++;" + UNICITY_PREFIX + "callbacks[callbackId] = callback;" + functionObjectVar + ".call('" + endManager.instanceId + "', q, callbackId);" + "};");
                            }
                            scriptBuilder.append(script);
                            scriptBuilder.append("};" + UNICITY_PREFIX + "closure" + closureId + "();" + UNICITY_PREFIX + "closure" + closureId + " = null;" + UNICITY_PREFIX + "closure" + closureId + " = undefined;");
                            String s = scriptBuilder.toString();
                            try {
                                ExecutorScriptRunner.this.scriptEngine.eval(s);
                            }
                            catch (Exception se) {
                                LOGGER.error("Script error: {}", (Object)s, (Object)se);
                                endManager.fail(new IOException(se));
                            }
                        }
                        finally {
                            endManager.dec();
                        }
                    }
                });
            }
        };
    }

    public static JsonElement jsonString(String b) {
        return new JsonPrimitive(b);
    }

    public static JsonElement jsonNumber(Number b) {
        return new JsonPrimitive(b);
    }

    public static JsonElement jsonBoolean(boolean b) {
        return new JsonPrimitive(Boolean.valueOf(b));
    }

    static {
        String mode = CONFIG.getString("ninio.script.mode");
        if (mode.equals("string")) {
            USE_TO_STRING = true;
            LOGGER.debug("Mode: string");
        } else if (mode.equals("json")) {
            USE_TO_STRING = false;
            LOGGER.debug("Mode: json");
        } else {
            throw new ConfigException.BadValue("script.mode", "Invalid mode, only allowed: json|string");
        }
        ENGINE_NAME = CONFIG.getString("ninio.script.engine");
        LOGGER.debug("Engine: {}", (Object)ENGINE_NAME);
        CALL_FUNCTION_NAME = CONFIG.getString("ninio.script.call");
        UNICITY_PREFIX = CONFIG.getString("ninio.script.unicity.prefix");
    }

    public final class AsyncInternal {
        private final String function;
        private final AsyncScriptFunction asyncFunction;

        private AsyncInternal(String function, AsyncScriptFunction asyncFunction) {
            this.function = function;
            this.asyncFunction = asyncFunction;
        }

        public void call(String instanceId, Object requestAsObject, final String callbackId) {
            JsonElement request = requestAsObject == null ? null : (USE_TO_STRING ? new JsonParser().parse((String)requestAsObject) : (JsonElement)requestAsObject);
            final EndManager endManager = (EndManager)ExecutorScriptRunner.this.endManagers.get(instanceId);
            endManager.inc();
            LOGGER.trace("Call {}, instanceId = {}, callbackId = {}, request = {}", new Object[]{this.function, instanceId, callbackId, request});
            this.asyncFunction.call(request, new AsyncScriptFunction.Callback(){

                @Override
                public void handle(final JsonElement response) {
                    if (ExecutorScriptRunner.this.executorService.isShutdown()) {
                        LOGGER.warn("Callback called after script engine has been closed");
                        return;
                    }
                    ExecutorScriptRunner.this.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            block12: {
                                if (endManager.isEnded()) {
                                    LOGGER.warn("Callback called on a terminated object");
                                    return;
                                }
                                try {
                                    try {
                                        if (USE_TO_STRING) {
                                            ExecutorScriptRunner.this.scriptEngine.eval("var " + UNICITY_PREFIX + "f = " + UNICITY_PREFIX + "callbacks['" + callbackId + "'];" + "delete " + UNICITY_PREFIX + "callbacks['" + callbackId + "'];" + "if (" + UNICITY_PREFIX + "f) " + UNICITY_PREFIX + "f(" + (response == null ? "null" : response.toString()) + ");" + UNICITY_PREFIX + "f = null;" + UNICITY_PREFIX + "f = undefined;");
                                            break block12;
                                        }
                                        if (response == null) {
                                            ExecutorScriptRunner.this.scriptEngine.eval("var " + UNICITY_PREFIX + "r = null;");
                                        } else {
                                            String id = String.valueOf(ExecutorScriptRunner.this.nextUnicityId);
                                            ExecutorScriptRunner.this.nextUnicityId++;
                                            ExecutorScriptRunner.this.scriptEngine.getBindings(100).put(UNICITY_PREFIX + "response" + id, (Object)response);
                                            try {
                                                ExecutorScriptRunner.this.scriptEngine.eval("var " + UNICITY_PREFIX + "r = " + UNICITY_PREFIX + "convertTo(" + UNICITY_PREFIX + "response" + id + ");");
                                            }
                                            finally {
                                                ExecutorScriptRunner.this.scriptEngine.getBindings(100).put(UNICITY_PREFIX + "response" + id, (Object)null);
                                                ExecutorScriptRunner.this.scriptEngine.getBindings(100).remove(UNICITY_PREFIX + "response" + id);
                                            }
                                        }
                                        ExecutorScriptRunner.this.scriptEngine.eval("var " + UNICITY_PREFIX + "f = " + UNICITY_PREFIX + "callbacks['" + callbackId + "'];" + "delete " + UNICITY_PREFIX + "callbacks['" + callbackId + "'];" + "if (" + UNICITY_PREFIX + "f) " + UNICITY_PREFIX + "f(" + UNICITY_PREFIX + "r);" + UNICITY_PREFIX + "r = null;" + UNICITY_PREFIX + "r = undefined;" + UNICITY_PREFIX + "f = null;" + UNICITY_PREFIX + "f = undefined;");
                                    }
                                    catch (Exception se) {
                                        endManager.fail(new IOException(se));
                                    }
                                }
                                finally {
                                    endManager.dec();
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    public final class SyncInternal {
        private final SyncScriptFunction syncFunction;

        private SyncInternal(SyncScriptFunction syncFunction) {
            this.syncFunction = syncFunction;
        }

        public Object call(Object requestAsObject) {
            JsonElement request = requestAsObject == null ? null : (USE_TO_STRING ? new JsonParser().parse((String)requestAsObject) : (JsonElement)requestAsObject);
            JsonElement response = this.syncFunction.call(request);
            if (response == null) {
                return null;
            }
            if (USE_TO_STRING) {
                return response.toString();
            }
            return response;
        }
    }

    private static final class EndManager {
        public final String instanceId;
        private int count = 0;
        private ScriptRunner.End end;
        private boolean ended = false;

        public EndManager(String instanceId, ScriptRunner.End end) {
            this.instanceId = instanceId;
            this.end = end;
        }

        public boolean isEnded() {
            return this.ended;
        }

        public void fail(Exception e) {
            this.ended = true;
            LOGGER.error("Failed", (Throwable)e);
            ScriptRunner.End ee = this.end;
            this.end = null;
            if (ee != null) {
                ee.failed(e);
            }
        }

        public void inc() {
            ++this.count;
        }

        public void dec() {
            --this.count;
            if (this.count == 0) {
                this.ended = true;
                ScriptRunner.End ee = this.end;
                this.end = null;
                if (ee != null) {
                    ee.ended();
                }
            }
        }
    }
}

