/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.string;

import com.google.common.base.Splitter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class CompositeString {
    private final String globalElementSeparator;
    private final String specificationSeparator;
    private final String keyValueListSeparator;
    private final String keyValueSeparator;
    private final boolean trim;

    public CompositeString(String globalElementSeparator, String specificationSeparator, String keyValueListSeparator, String keyValueSeparator, boolean trim) {
        this.globalElementSeparator = globalElementSeparator;
        this.specificationSeparator = specificationSeparator;
        this.keyValueListSeparator = keyValueListSeparator;
        this.keyValueSeparator = keyValueSeparator;
        this.trim = trim;
    }

    public SubCompositeString on(String s) {
        return new InnerSubCompositeString(this.globalElementSeparator, this.specificationSeparator, this.keyValueListSeparator, this.keyValueSeparator, this.trim, s);
    }

    private static final class InnerNext
    implements Next {
        private final int firstColon;
        private final String type;
        private final Suffix suffix;
        private final String s;

        private InnerNext(String globalElementSeparator, String specificationSeparator, String keyValueListSeparator, String keyValueSeparator, boolean trim, String s) {
            this.s = s;
            this.firstColon = specificationSeparator == null ? -1 : s.indexOf(specificationSeparator);
            if (this.firstColon < 0) {
                this.type = null;
                this.suffix = new InnerSuffix(globalElementSeparator, specificationSeparator, keyValueListSeparator, keyValueSeparator, trim, s);
            } else {
                this.type = s.substring(0, this.firstColon);
                this.suffix = new InnerSuffix(globalElementSeparator, specificationSeparator, keyValueListSeparator, keyValueSeparator, trim, s.substring(this.firstColon + 1));
            }
        }

        @Override
        public String specification() {
            return this.type;
        }

        @Override
        public Suffix suffix() {
            return this.suffix;
        }

        public String toString() {
            return this.s;
        }
    }

    private static final class InnerSubCompositeString
    implements SubCompositeString {
        private final int firstSlash;
        private final String prefix;
        private final Next next;

        private InnerSubCompositeString(String globalElementSeparator, String specificationSeparator, String keyValueListSeparator, String keyValueSeparator, boolean trim, String s) {
            this.firstSlash = globalElementSeparator == null ? -1 : s.indexOf(globalElementSeparator);
            if (this.firstSlash < 0) {
                this.prefix = null;
                this.next = new InnerNext(globalElementSeparator, specificationSeparator, keyValueListSeparator, keyValueSeparator, trim, s);
            } else {
                this.prefix = s.substring(0, this.firstSlash);
                this.next = new InnerNext(globalElementSeparator, specificationSeparator, keyValueListSeparator, keyValueSeparator, trim, s.substring(this.firstSlash + 1));
            }
        }

        @Override
        public String prefix() {
            return this.prefix;
        }

        @Override
        public Next next() {
            return this.next;
        }

        @Override
        public Iterable<String> specification() {
            LinkedList<String> s = new LinkedList<String>();
            Next n = this.next;
            while (n != null) {
                s.add(n.specification());
                n = n.suffix().next();
            }
            return s;
        }

        @Override
        public String value(String key) {
            Next n = this.next;
            while (n != null) {
                String v = n.suffix().value(key);
                if (v != null) {
                    return v;
                }
                n = n.suffix().next();
            }
            return null;
        }
    }

    private static final class InnerSuffix
    implements Suffix {
        private final String keyValueListSeparator;
        private final String keyValueSeparator;
        private final boolean trim;
        private final String s;
        private final int nextColon;
        private final int slashBeforeNextColon;
        private Map<String, String> values = null;
        private final Next next;

        private InnerSuffix(String globalElementSeparator, String specificationSeparator, String keyValueListSeparator, String keyValueSeparator, boolean trim, String s) {
            this.s = s;
            this.keyValueListSeparator = keyValueListSeparator;
            this.keyValueSeparator = keyValueSeparator;
            this.trim = trim;
            this.nextColon = specificationSeparator == null ? -1 : s.indexOf(specificationSeparator);
            this.slashBeforeNextColon = this.nextColon < 0 ? -1 : (globalElementSeparator == null ? -1 : s.lastIndexOf(globalElementSeparator, this.nextColon));
            this.next = this.slashBeforeNextColon < 0 ? null : new InnerNext(globalElementSeparator, specificationSeparator, keyValueListSeparator, keyValueSeparator, trim, s.substring(this.slashBeforeNextColon + 1));
        }

        public String toString() {
            return this.s;
        }

        private Map<String, String> split() {
            if (this.values != null) {
                return this.values;
            }
            this.values = new HashMap<String, String>();
            String toSplit = this.slashBeforeNextColon < 0 ? this.s : this.s.substring(0, this.slashBeforeNextColon);
            for (String t : Splitter.on((String)this.keyValueListSeparator).splitToList((CharSequence)(this.trim ? toSplit.trim() : toSplit))) {
                List kv = Splitter.on((String)this.keyValueSeparator).splitToList((CharSequence)(this.trim ? t.trim() : t));
                this.values.put((String)kv.get(0), (String)kv.get(1));
            }
            return this.values;
        }

        @Override
        public String value(String key) {
            return this.split().get(key);
        }

        @Override
        public Next next() {
            return this.next;
        }
    }

    public static interface Next {
        public String specification();

        public Suffix suffix();
    }

    public static interface SubCompositeString {
        public String prefix();

        public Next next();

        public String value(String var1);

        public Iterable<String> specification();
    }

    public static interface Suffix {
        public String value(String var1);

        public Next next();
    }
}

