/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.string;

import com.davfx.ninio.string.Extraction;
import com.davfx.ninio.string.Extractor;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfiguredExtraction
implements Extraction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfiguredExtraction.class);
    private final ExtractConfiguration root;
    private final boolean ignoreWhitespaces;

    public ConfiguredExtraction(Config config) {
        this.ignoreWhitespaces = config.getBoolean("whitespaces.ignore");
        this.root = ExtractConfiguration.build(config);
        ExtractConfiguration.listsToArrays(this.root);
    }

    @Override
    public void run(Reader reader, Extraction.Handler handler) throws IOException {
        this.root.run(new LinkedList<Map<String, String>>(), new Extractor().on(reader).ignoreWhitespaces(this.ignoreWhitespaces), handler);
    }

    private static final class ExtractConfiguration {
        List<String> fromList = new LinkedList<String>();
        String[] from;
        Map<String, List<String>> toLists = new HashMap<String, List<String>>();
        Map<String, String[]> to = new HashMap<String, String[]>();
        Map<String, String> keys = new HashMap<String, String>();
        Map<String, ExtractConfiguration> sub = new HashMap<String, ExtractConfiguration>();

        private ExtractConfiguration() {
        }

        private static List<String> getStringList(Config c, String key) {
            ConfigValue v = c.getValue(key);
            if (v.valueType() == ConfigValueType.LIST) {
                List l = c.getStringList(key);
                if (l.isEmpty()) {
                    throw new RuntimeException("Cannot be empty: " + key);
                }
                return l;
            }
            LinkedList<String> l = new LinkedList<String>();
            l.add(c.getString(key));
            return l;
        }

        public static ExtractConfiguration build(Config config) {
            ExtractConfiguration root = new ExtractConfiguration();
            if (config.hasPath("extract")) {
                for (Config c : config.getConfigList("extract")) {
                    List<String> f = ExtractConfiguration.getStringList(c, "from");
                    List<String> t = ExtractConfiguration.getStringList(c, "to");
                    for (String ff : f) {
                        if (!root.fromList.contains(ff)) continue;
                        throw new RuntimeException("'from' conflict (" + ff + " duplicated)");
                    }
                    root.fromList.addAll(f);
                    if (c.hasPath("key")) {
                        String key = c.getString("key");
                        for (String from : f) {
                            root.keys.put(from, key);
                        }
                    }
                    ExtractConfiguration sub = ExtractConfiguration.build(c);
                    for (String from : f) {
                        root.toLists.put(from, t);
                        root.sub.put(from, sub);
                    }
                }
            }
            return root;
        }

        public static void listsToArrays(ExtractConfiguration e) {
            if (e.fromList != null) {
                for (String string : e.fromList) {
                    for (List<String> l : e.toLists.values()) {
                        for (String t : l) {
                            if (!t.startsWith(string)) continue;
                            throw new RuntimeException("'to'/'from' conflict");
                        }
                    }
                }
                e.from = e.fromList.toArray(new String[e.fromList.size()]);
                e.fromList = null;
            }
            if (e.toLists != null) {
                for (Map.Entry entry : e.toLists.entrySet()) {
                    e.to.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
                }
                e.toLists = null;
            }
            for (ExtractConfiguration extractConfiguration : e.sub.values()) {
                ExtractConfiguration.listsToArrays(extractConfiguration);
            }
        }

        public void run(Deque<Map<String, String>> keyValuesList, Extractor extractor, Extraction.Handler handler) throws IOException {
            Extractor main = extractor.from(this.from);
            LinkedHashMap<String, String> keyValues = new LinkedHashMap<String, String>();
            keyValuesList.addLast(keyValues);
            while (true) {
                LOGGER.trace("Search: from = {}", Arrays.asList(this.from));
                Extractor e = main.extract();
                if (e == null) break;
                String found = e.found();
                String[] t = this.to.get(found);
                e.to(t);
                String key = this.keys.get(found);
                if (key != null) {
                    e.accumulate();
                }
                LOGGER.trace("Found: key = {}, found = {}, to = {}", new Object[]{key, found, Arrays.asList(t)});
                ExtractConfiguration c = this.sub.get(found);
                if (c.from.length == 0) {
                    e.extract();
                } else {
                    c.run(keyValuesList, e, handler);
                }
                if (key == null) continue;
                String value = e.accumulated();
                keyValues.put(key, value);
            }
            handler.exit(new ArrayList<Map<String, String>>(keyValuesList));
            keyValuesList.removeLast();
        }
    }
}

