/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.string;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;

public final class Extractor {
    private String[] from = new String[0];
    private String[] to = new String[0];
    private Reader on = null;
    private final String found;
    private StringBuilder accumulator = null;
    private final List<StringBuilder> accumulators;
    private boolean ignoreWhitespaces = false;

    public Extractor() {
        this(null, new LinkedList<StringBuilder>());
    }

    private Extractor(String found, List<StringBuilder> accumulators) {
        this.found = found;
        this.accumulators = accumulators;
    }

    public Extractor ignoreWhitespaces(boolean ignoreWhitespaces) {
        this.ignoreWhitespaces = ignoreWhitespaces;
        return this;
    }

    public Extractor from(String ... from) {
        this.from = from;
        return this;
    }

    public Extractor to(String ... to) {
        this.to = to;
        return this;
    }

    public Extractor on(Reader on) {
        this.on = on;
        return this;
    }

    public Extractor accumulate() {
        this.accumulator = new StringBuilder();
        this.accumulators.add(this.accumulator);
        return this;
    }

    public String found() {
        return this.found;
    }

    public String accumulated() {
        return this.accumulator.toString();
    }

    public String contents() throws IOException {
        this.accumulate();
        this.extract();
        return this.accumulated();
    }

    /*
     * Unable to fully structure code
     */
    public Extractor extract() throws IOException {
        iFrom = new int[this.from.length];
        iTo = new int[this.to.length];
        block0: while (true) {
            if ((k = this.on.read()) < 0) {
                return null;
            }
            c = (char)k;
            for (StringBuilder b : this.accumulators) {
                b.append(c);
            }
            if (this.ignoreWhitespaces && Character.isWhitespace(c)) continue;
            u = 0;
            while (u < iFrom.length) {
                if (c == this.from[u].charAt(iFrom[u])) {
                    v0 = u;
                    iFrom[v0] = iFrom[v0] + 1;
                    if (iFrom[u] == this.from[u].length()) {
                        return new Extractor(this.from[u], Lists.newLinkedList(this.accumulators)).on(this.on).to(this.to).ignoreWhitespaces(this.ignoreWhitespaces);
                    }
                } else if (iFrom[u] > 0) {
                    iFrom[u] = 0;
                    if (c == this.from[u].charAt(iFrom[u])) {
                        v1 = u;
                        iFrom[v1] = iFrom[v1] + 1;
                        if (iFrom[u] == this.from[u].length()) {
                            return new Extractor(this.from[u], Lists.newLinkedList(this.accumulators)).on(this.on).to(this.to).ignoreWhitespaces(this.ignoreWhitespaces);
                        }
                    }
                }
                ++u;
            }
            u = 0;
            while (true) {
                if (u < iTo.length) ** break;
                continue block0;
                if (c == this.to[u].charAt(iTo[u])) {
                    v2 = u;
                    iTo[v2] = iTo[v2] + 1;
                    if (iTo[u] == this.to[u].length()) {
                        if (this.accumulator != null) {
                            this.accumulator.delete(this.accumulator.length() - this.to[u].length(), this.accumulator.length());
                        }
                        return null;
                    }
                } else if (iTo[u] > 0) {
                    iTo[u] = 0;
                    if (c == this.to[u].charAt(iTo[u])) {
                        v3 = u;
                        iTo[v3] = iTo[v3] + 1;
                        if (iTo[u] == this.to[u].length()) {
                            if (this.accumulator != null) {
                                this.accumulator.delete(this.accumulator.length() - this.to[u].length(), this.accumulator.length());
                            }
                            return null;
                        }
                    }
                }
                ++u;
            }
            break;
        }
    }
}

