/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.string;

import com.davfx.ninio.string.AfterStringInput;
import com.davfx.ninio.string.AppendStringInput;
import com.davfx.ninio.string.BeforeStringInput;
import com.davfx.ninio.string.BitComposeStringInput;
import com.davfx.ninio.string.CleanStringInput;
import com.davfx.ninio.string.CompositePrefixStringInput;
import com.davfx.ninio.string.CompositeSpecificationStringInput;
import com.davfx.ninio.string.CompositeValueStringInput;
import com.davfx.ninio.string.EscapingStringInput;
import com.davfx.ninio.string.FindStringInput;
import com.davfx.ninio.string.GetPrefixStringInput;
import com.davfx.ninio.string.GetSuffixStringInput;
import com.davfx.ninio.string.IfEqStringInput;
import com.davfx.ninio.string.IfNullStringInput;
import com.davfx.ninio.string.NullStringInput;
import com.davfx.ninio.string.RemovePrefixStringInput;
import com.davfx.ninio.string.RemoveSuffixStringInput;
import com.davfx.ninio.string.ReplaceStringInput;
import com.davfx.ninio.string.StringInput;
import com.davfx.ninio.string.StringInputFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public final class StringHandler<T> {
    private final Map<String, StringInputFactory<T>> factories = new HashMap<String, StringInputFactory<T>>();

    private static final int find(boolean skipBlocks, String s, char toFind, int from) {
        int open = 0;
        boolean escaping = false;
        int i = from;
        while (i < s.length()) {
            if (escaping) {
                escaping = false;
            } else {
                char c = s.charAt(i);
                if (c == '\\') {
                    escaping = true;
                } else {
                    if (open == 0 && c == toFind) {
                        return i;
                    }
                    if (skipBlocks && c == '{') {
                        ++open;
                    } else if (skipBlocks && c == '}') {
                        --open;
                    }
                }
            }
            ++i;
        }
        return -1;
    }

    public StringHandler() {
        this.factories.put("null", new StringInputFactory<T>(){

            @Override
            public StringInput<T> build(StringInput<T>[] inputs) {
                return new NullStringInput();
            }
        });
        this.factories.put("before", new StringInputFactory<T>(){

            @Override
            public StringInput<T> build(StringInput<T>[] inputs) {
                return new BeforeStringInput(inputs[0], inputs[1]);
            }
        });
        this.factories.put("after", new StringInputFactory<T>(){

            @Override
            public StringInput<T> build(StringInput<T>[] inputs) {
                return new AfterStringInput(inputs[0], inputs[1]);
            }
        });
        this.factories.put("clean", new StringInputFactory<T>(){

            @Override
            public StringInput<T> build(StringInput<T>[] inputs) {
                return new CleanStringInput(inputs[0]);
            }
        });
        this.factories.put("ifnull", new StringInputFactory<T>(){

            @Override
            public StringInput<T> build(StringInput<T>[] inputs) {
                IfNullStringInput input = new IfNullStringInput();
                StringInput<T>[] stringInputArray = inputs;
                int n = inputs.length;
                int n2 = 0;
                while (n2 < n) {
                    StringInput in = stringInputArray[n2];
                    input.add(in);
                    ++n2;
                }
                return input;
            }
        });
        this.factories.put("bitcompose", new StringInputFactory<T>(){

            @Override
            public StringInput<T> build(StringInput<T>[] inputs) {
                return new BitComposeStringInput(inputs[0], inputs[1], inputs[2]);
            }
        });
        this.factories.put("compositeprefix", new StringInputFactory<T>(){

            @Override
            public StringInput<T> build(StringInput<T>[] inputs) {
                return new CompositePrefixStringInput(inputs[0], inputs[1], inputs[2], inputs[3], inputs[4], inputs[5]);
            }
        });
        this.factories.put("compositespecification", new StringInputFactory<T>(){

            @Override
            public StringInput<T> build(StringInput<T>[] inputs) {
                return new CompositeSpecificationStringInput(inputs[0], inputs[1], inputs[2], inputs[3], inputs[4], inputs[5]);
            }
        });
        this.factories.put("compositevalue", new StringInputFactory<T>(){

            @Override
            public StringInput<T> build(StringInput<T>[] inputs) {
                return new CompositeValueStringInput(inputs[0], inputs[1], inputs[2], inputs[3], inputs[4], inputs[5], inputs[6]);
            }
        });
        this.factories.put("removeprefix", new StringInputFactory<T>(){

            @Override
            public StringInput<T> build(StringInput<T>[] inputs) {
                return new RemovePrefixStringInput(inputs[0], inputs[1]);
            }
        });
        this.factories.put("removesuffix", new StringInputFactory<T>(){

            @Override
            public StringInput<T> build(StringInput<T>[] inputs) {
                return new RemoveSuffixStringInput(inputs[0], inputs[1]);
            }
        });
        this.factories.put("getprefix", new StringInputFactory<T>(){

            @Override
            public StringInput<T> build(StringInput<T>[] inputs) {
                return new GetPrefixStringInput(inputs[0], inputs[1]);
            }
        });
        this.factories.put("getsuffix", new StringInputFactory<T>(){

            @Override
            public StringInput<T> build(StringInput<T>[] inputs) {
                return new GetSuffixStringInput(inputs[0], inputs[1]);
            }
        });
        this.factories.put("find", new StringInputFactory<T>(){

            @Override
            public StringInput<T> build(StringInput<T>[] inputs) {
                return new FindStringInput(inputs[0], inputs[1], inputs[2]);
            }
        });
        this.factories.put("replace", new StringInputFactory<T>(){

            @Override
            public StringInput<T> build(StringInput<T>[] inputs) {
                return new ReplaceStringInput(inputs[0], inputs[1], inputs[2]);
            }
        });
        this.factories.put("ifeq", new StringInputFactory<T>(){

            @Override
            public StringInput<T> build(StringInput<T>[] inputs) {
                return new IfEqStringInput(inputs[0], inputs[1], inputs[2], inputs[3]);
            }
        });
    }

    public StringHandler<T> add(String keyword, StringInputFactory<T> factory) {
        this.factories.put(keyword, factory);
        return this;
    }

    private StringInput<T> buildStringInput(String s) {
        String remaining;
        String keyword;
        int c = StringHandler.find(true, s, ':', 1);
        if (c < 0) {
            keyword = s.substring(1, s.length() - 1);
            remaining = null;
        } else {
            keyword = s.substring(1, c);
            remaining = s.substring(c + 1, s.length() - 1);
        }
        LinkedList<StringInput<T>> l = new LinkedList<StringInput<T>>();
        if (remaining != null) {
            int i = 0;
            while (true) {
                int d;
                if ((d = StringHandler.find(true, remaining, ':', i)) < 0) {
                    l.add(this.buildCompleteStringInput(remaining.substring(i)));
                    break;
                }
                l.add(this.buildCompleteStringInput(remaining.substring(i, d)));
                i = d + 1;
            }
        }
        final StringInput<T> keywordInput = this.buildCompleteStringInput(keyword);
        final StringInput[] inputs = new StringInput[l.size()];
        l.toArray(inputs);
        return new StringInput<T>(){

            @Override
            public String get(T h) {
                String kw = keywordInput.get(h);
                StringInputFactory factory = (StringInputFactory)StringHandler.this.factories.get(kw);
                if (factory == null) {
                    throw new RuntimeException("Invalid keyword: " + kw);
                }
                StringInput input = factory.build(inputs);
                if (input == null) {
                    throw new RuntimeException("Invalid factory: " + kw);
                }
                return input.get(h);
            }
        };
    }

    private StringInput<T> buildCompleteStringInput(String s) {
        AppendStringInput<T> inputs = new AppendStringInput<T>();
        int last = 0;
        while (true) {
            int a;
            if ((a = StringHandler.find(false, s, '{', last)) < 0) {
                if (last >= s.length()) break;
                inputs.add(new EscapingStringInput(s.substring(last)));
                break;
            }
            if (last < a) {
                inputs.add(new EscapingStringInput(s.substring(last, a)));
            }
            int b = StringHandler.find(true, s, '}', a + 1);
            inputs.add(this.buildStringInput(s.substring(a, b + 1)));
            last = b + 1;
        }
        return inputs;
    }

    public StringInput<T> build(String configuration) {
        return this.buildCompleteStringInput(configuration);
    }
}

