/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.util;

import com.davfx.ninio.util.Dependencies;
import com.google.common.base.Charsets;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigUtils.class);

    private ConfigUtils() {
    }

    public static double getDuration(Config c, String key) {
        return (double)c.getDuration(key, TimeUnit.NANOSECONDS) / 1.0E9;
    }

    public static char getChar(Config c, String key) {
        String s = c.getString(key);
        if (s.length() != 1) {
            throw new ConfigException.BadValue(key, "Invalid value: " + s + ". Char value must be a string with only one character.");
        }
        return s.charAt(0);
    }

    private static InputStream getResource(Dependencies dependencies, String resource) {
        LOGGER.trace("Getting resource: {} with {}", (Object)(String.valueOf(resource) + ".conf"), (Object)dependencies.getClass().getClassLoader());
        InputStream i = dependencies.getClass().getClassLoader().getResourceAsStream(String.valueOf(resource) + ".conf");
        if (i == null) {
            LOGGER.trace("Getting resource: {} with {}", (Object)(String.valueOf(resource) + ".conf --> null"), (Object)dependencies.getClass().getClassLoader());
            Dependencies[] dependenciesArray = dependencies.dependencies();
            int n = dependenciesArray.length;
            int n2 = 0;
            while (n2 < n) {
                Dependencies d = dependenciesArray[n2];
                i = ConfigUtils.getResource(d, resource);
                if (i != null) {
                    return i;
                }
                ++n2;
            }
            return null;
        }
        return i;
    }

    private static String loadConfig(Dependencies dependencies, String resource, boolean warn) throws IOException {
        InputStream i;
        File rootDir = new File(".");
        LOGGER.trace("Absolute path: {}", (Object)rootDir.getAbsolutePath());
        File f = new File(rootDir, String.valueOf(resource) + ".conf");
        if (f.exists()) {
            i = new FileInputStream(f);
        } else {
            i = ConfigUtils.getResource(dependencies, resource);
            if (i == null) {
                if (warn) {
                    LOGGER.warn("Config file not found: {}", (Object)resource);
                    throw new RuntimeException("Config file not found: " + resource);
                }
                return "";
            }
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (BufferedReader r = new BufferedReader(new InputStreamReader(i, Charsets.UTF_8));){
            StringBuilder b = new StringBuilder();
            while (true) {
                String line;
                if ((line = r.readLine()) == null) {
                    return b.toString();
                }
                String l = line.trim();
                if (l.startsWith("include ")) {
                    b.append(ConfigUtils.loadConfig(dependencies, l.substring("include ".length()).trim(), true));
                } else {
                    b.append(line);
                }
                b.append("\n");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static synchronized Config load(Dependencies dependencies, String resource) {
        return ConfigUtils.load(dependencies, resource, new Override());
    }

    private static void gatherDependencies(Dependencies dependencies, List<Dependencies> l) {
        Dependencies[] dependenciesArray = dependencies.dependencies();
        int n = dependenciesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Dependencies d = dependenciesArray[n2];
            ConfigUtils.gatherDependencies(d, l);
            ++n2;
        }
        if (!l.contains(dependencies)) {
            l.add(dependencies);
        }
    }

    public static synchronized Config load(Dependencies dependencies, String resource, Override override) {
        String a;
        StringBuilder c = new StringBuilder();
        LinkedList<Dependencies> l = new LinkedList<Dependencies>();
        ConfigUtils.gatherDependencies(dependencies, l);
        for (Dependencies d : l) {
            String r;
            String packageName = d.getClass().getPackage().getName();
            LOGGER.trace("Dependency conf: {}", (Object)packageName);
            if (!packageName.endsWith(".dependencies")) {
                throw new RuntimeException("Must ends with '.dependencies': " + packageName);
            }
            packageName = packageName.substring(0, packageName.length() - ".dependencies".length());
            try {
                r = ConfigUtils.loadConfig(d, packageName, true);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load package config", e);
            }
            c.append(r);
        }
        if (resource != null) {
            String r;
            try {
                r = ConfigUtils.loadConfig(dependencies, resource, true);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load package config", e);
            }
            c.append(r);
        }
        try {
            a = ConfigUtils.loadConfig(dependencies, "configure-" + resource, false);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load application config", e);
        }
        c.append('\n');
        c.append(a);
        try {
            a = ConfigUtils.loadConfig(dependencies, "configure", false);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load application config", e);
        }
        c.append('\n');
        c.append(a);
        for (String o : override.override) {
            c.append('\n');
            c.append(o);
        }
        String conf = c.toString();
        LOGGER.trace("Config: \n{}\n", (Object)conf);
        return ConfigFactory.parseString((String)conf).resolve();
    }

    public static synchronized Config load(Dependencies dependencies) {
        return ConfigUtils.load(dependencies, null, new Override());
    }

    public static final class Override {
        private final List<String> override = new LinkedList<String>();

        public Override add(String config) {
            this.override.add(config);
            return this;
        }

        public Override add(String key, String value) {
            this.override.add(String.valueOf(key) + " = \"" + value.replace("\\", "\\\\").replace("\"", "\\\"") + "\"");
            return this;
        }
    }
}

