/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibraryLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(LibraryLoader.class);
    private static final int COPY_BUFFER_SIZE = 10240;

    private LibraryLoader() {
    }

    private static String convertName(String name) {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") > 0) {
            return "lib" + name + ".so";
        }
        if (os.indexOf("mac") >= 0) {
            return "lib" + name + ".dylib";
        }
        if (os.indexOf("win") >= 0) {
            return String.valueOf(name) + ".dll";
        }
        throw new UnsatisfiedLinkError("Unknow OS: " + os);
    }

    public static void load(ClassLoader classLoader, String path) {
        try {
            File to;
            int i = path.lastIndexOf(47);
            path = i < 0 ? LibraryLoader.convertName(path) : String.valueOf(path.substring(0, i)) + "/" + LibraryLoader.convertName(path.substring(i + 1));
            InputStream in = classLoader.getResourceAsStream(path);
            if (in == null) {
                throw new UnsatisfiedLinkError("Resource not found: " + path);
            }
            try {
                try {
                    to = File.createTempFile("lib", ".lib");
                    Throwable throwable = null;
                    Object var6_9 = null;
                    try (FileOutputStream out = new FileOutputStream(to);){
                        int l;
                        byte[] b = new byte[10240];
                        while ((l = in.read(b)) > 0) {
                            ((OutputStream)out).write(b, 0, l);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ioe) {
                throw new UnsatisfiedLinkError("Library could not be loaded: " + ioe.getMessage());
            }
            System.load(to.getAbsolutePath());
        }
        catch (Throwable ee) {
            LOGGER.error("Could not load library: " + path, ee);
            throw ee;
        }
    }
}

