/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Lock<R, E extends Exception> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Lock.class);
    private boolean done = false;
    private R result = null;
    private E fail = null;

    public synchronized R waitFor() throws E {
        while (true) {
            if (this.fail != null) {
                throw this.fail;
            }
            if (this.done) {
                return this.result;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public synchronized void set(R result) {
        if (this.done) {
            LOGGER.warn("Set multiple times (current result = {}, overwritten result = {}, fail = {})", new Object[]{this.result, result, this.fail, null});
        }
        this.result = result;
        this.done = true;
        this.notifyAll();
    }

    public synchronized void fail(E fail) {
        if (this.done) {
            LOGGER.warn("Failed multiple times (current fail = {}, overwritten fail = {}, result = {})", new Object[]{this.fail, fail, this.result, null});
        }
        this.fail = fail;
        this.done = true;
        this.notifyAll();
    }
}

