/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.util;

import com.davfx.ninio.util.ConfigUtils;
import com.davfx.ninio.util.DateUtils;
import com.davfx.ninio.util.dependencies.Dependencies;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.typesafe.config.Config;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class MemoryCache<K, V> {
    private static final Config CONFIG = ConfigUtils.load(new Dependencies()).getConfig(MemoryCache.class.getPackage().getName());
    private static final double DEFAULT_CHECK_TIME = ConfigUtils.getDuration(CONFIG, "cache.default.check");
    private final double expirationAfterAccess;
    private final double expirationAfterWrite;
    private final int limit;
    private final double checkTime;
    private double lastCheck = 0.0;
    private final Map<K, Element<V>> map = new LinkedHashMap<K, Element<V>>();

    public static <K, V> Builder<K, V> builder() {
        return new Builder<K, V>(){
            private double expirationAfterAccess = 0.0;
            private double expirationAfterWrite = 0.0;
            private double checkTime = MemoryCache.access$0();
            private int limit = 0;

            @Override
            public Builder<K, V> expireAfterAccess(double expiration) {
                this.expirationAfterAccess = expiration;
                return this;
            }

            @Override
            public Builder<K, V> expireAfterWrite(double expiration) {
                this.expirationAfterWrite = expiration;
                return this;
            }

            @Override
            public Builder<K, V> limitedTo(int limit) {
                this.limit = limit;
                return this;
            }

            @Override
            public Builder<K, V> check(double checkTime) {
                this.checkTime = checkTime;
                return this;
            }

            @Override
            public MemoryCache<K, V> build() {
                return new MemoryCache(this.expirationAfterAccess, this.expirationAfterWrite, this.limit, this.checkTime, null);
            }
        };
    }

    private MemoryCache(double expirationAfterAccess, double expirationAfterWrite, int limit, double checkTime) {
        this.expirationAfterAccess = expirationAfterAccess;
        this.expirationAfterWrite = expirationAfterWrite;
        this.limit = limit;
        this.checkTime = checkTime;
    }

    public String toString() {
        StringBuilder b = new StringBuilder().append('{');
        boolean first = true;
        for (Map.Entry<K, Element<V>> e : this.map.entrySet()) {
            if (!first) {
                b.append(',');
            } else {
                first = false;
            }
            b.append(e.getKey()).append('=').append(e.getValue().v);
        }
        b.append('}');
        return b.toString();
    }

    public void put(K key, V value) {
        try {
            double now = DateUtils.now();
            Element<V> e = new Element<V>(value);
            e.writeTimestamp = now;
            e.accessTimestamp = now;
            this.map.remove(key);
            this.map.put(key, e);
            if (this.limit > 0 && this.map.size() > this.limit) {
                Iterator<Map.Entry<K, Element<V>>> i = this.map.entrySet().iterator();
                i.next();
                i.remove();
            }
        }
        finally {
            this.check();
        }
    }

    public V get(K key) {
        try {
            Element<V> e = this.map.remove(key);
            if (e == null) {
                return null;
            }
            double now = DateUtils.now();
            if (this.expirationAfterAccess > 0.0 && now - e.accessTimestamp >= this.expirationAfterAccess) {
                this.map.remove(key);
                return null;
            }
            if (this.expirationAfterWrite > 0.0 && now - e.writeTimestamp >= this.expirationAfterWrite) {
                this.map.remove(key);
                return null;
            }
            e.accessTimestamp = now;
            this.map.put(key, e);
            Object v = e.v;
            return v;
        }
        finally {
            this.check();
        }
    }

    public void remove(K key) {
        try {
            this.map.remove(key);
        }
        finally {
            this.check();
        }
    }

    public void clear() {
        try {
            this.map.clear();
        }
        finally {
            this.check();
        }
    }

    private void check() {
        Iterator<Element<V>> i;
        double now = DateUtils.now();
        if (now - this.lastCheck < this.checkTime) {
            return;
        }
        this.lastCheck = now;
        if (this.expirationAfterAccess > 0.0) {
            i = this.map.values().iterator();
            while (i.hasNext()) {
                if (!(now - i.next().accessTimestamp > this.expirationAfterAccess)) continue;
                i.remove();
            }
        }
        if (this.expirationAfterWrite > 0.0) {
            i = this.map.values().iterator();
            while (i.hasNext()) {
                if (!(now - i.next().writeTimestamp > this.expirationAfterWrite)) continue;
                i.remove();
            }
        }
    }

    public Iterable<K> keys() {
        this.check();
        return this.map.keySet();
    }

    public Iterable<V> values() {
        this.check();
        return Iterables.transform(this.map.values(), (Function)new Function<Element<V>, V>(){

            public V apply(Element<V> e) {
                return e.v;
            }
        });
    }

    public Iterable<Map.Entry<K, V>> entries() {
        this.check();
        return Iterables.transform(this.map.entrySet(), (Function)new Function<Map.Entry<K, Element<V>>, Map.Entry<K, V>>(){

            public Map.Entry<K, V> apply(Map.Entry<K, Element<V>> e) {
                return new InnerMapEntry(e);
            }
        });
    }

    static /* synthetic */ double access$0() {
        return DEFAULT_CHECK_TIME;
    }

    /* synthetic */ MemoryCache(double d, double d2, int n, double d3, MemoryCache memoryCache) {
        this(d, d2, n, d3);
    }

    public static interface Builder<K, V> {
        public Builder<K, V> expireAfterAccess(double var1);

        public Builder<K, V> expireAfterWrite(double var1);

        public Builder<K, V> check(double var1);

        public Builder<K, V> limitedTo(int var1);

        public MemoryCache<K, V> build();
    }

    private static final class Element<V> {
        public double writeTimestamp;
        public double accessTimestamp;
        public final V v;

        public Element(V v) {
            this.v = v;
        }
    }

    private static final class InnerMapEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<K, Element<V>> e;

        public InnerMapEntry(Map.Entry<K, Element<V>> e) {
            this.e = e;
        }

        @Override
        public K getKey() {
            return this.e.getKey();
        }

        @Override
        public V getValue() {
            return this.e.getValue().v;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.e.getKey(), this.e.getValue().v);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InnerMapEntry)) {
                return false;
            }
            InnerMapEntry a = (InnerMapEntry)o;
            return Objects.equals(this.e.getKey(), a.e.getKey()) && Objects.equals(this.e.getValue(), a.e.getValue());
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

