/*
 * Decompiled with CFR 0.152.
 */
package com.davidrandoll.spring_web_captor.body_parser.parsers;

import com.davidrandoll.spring_web_captor.body_parser.IRequestBodyParser;
import com.davidrandoll.spring_web_captor.event.BodyPayload;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.lang.NonNull;
import org.springframework.util.MultiValueMap;

@Order(value=1)
public class FormUrlEncodedRequestBodyParser
implements IRequestBodyParser {
    @Override
    public boolean supports(String contentType) {
        return contentType != null && contentType.contains("x-www-form-urlencoded");
    }

    @Override
    public BodyPayload parse(ServletRequest request, byte[] body) throws IOException {
        JsonNodeFactory factory = JsonNodeFactory.instance;
        ObjectNode objectNode = factory.objectNode();
        FormHttpMessageConverter converter = new FormHttpMessageConverter();
        HttpInputMessage inputMessage = FormUrlEncodedRequestBodyParser.toHttpInputMessage(request);
        MultiValueMap formData = converter.read(null, inputMessage);
        formData.forEach((key, values) -> {
            if (values.size() == 1) {
                objectNode.put(key, (String)values.getFirst());
            } else {
                ArrayNode arrayNode = factory.arrayNode();
                for (String value : values) {
                    arrayNode.add(value);
                }
                objectNode.set(key, (JsonNode)arrayNode);
            }
        });
        return new BodyPayload((JsonNode)objectNode);
    }

    @NonNull
    private static HttpInputMessage toHttpInputMessage(ServletRequest request) {
        ServletRequest servletRequest = request;
        Objects.requireNonNull(servletRequest);
        ServletRequest servletRequest2 = servletRequest;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HttpInputMessage.class, HttpServletRequest.class}, (Object)servletRequest2, n)) {
            case 0 -> {
                HttpInputMessage httpInputMessage;
                yield httpInputMessage = (HttpInputMessage)servletRequest2;
            }
            case 1 -> {
                HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest2;
                yield new ServletServerHttpRequest(httpServletRequest);
            }
            default -> throw new IllegalArgumentException("Request must be an instance of HttpServletRequest or HttpInputMessage");
        };
    }
}

